/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent.batcher;

import com.terraforged.core.util.concurrent.batcher.Batcher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class AsyncBatcher
implements Batcher {
    private final List<Future<?>> tasks;
    private final ExecutorService executor;

    public AsyncBatcher(ExecutorService executor, int size) {
        this.executor = executor;
        this.tasks = new ArrayList(size);
    }

    @Override
    public void submit(Runnable task) {
        this.tasks.add(this.executor.submit(task));
    }

    @Override
    public void submit(Callable<?> task) {
        this.tasks.add(this.executor.submit(task));
    }

    @Override
    public void close() {
        boolean hasMore = true;
        while (hasMore) {
            hasMore = false;
            for (Future<?> future : this.tasks) {
                if (future.isDone()) continue;
                hasMore = true;
            }
        }
        this.tasks.clear();
    }
}

