/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.region;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Extent;
import com.terraforged.core.filter.Filterable;
import com.terraforged.core.region.Size;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.region.chunk.ChunkWriter;
import com.terraforged.core.util.concurrent.Disposable;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.rivermap.RiverRegionList;
import com.terraforged.core.world.terrain.Terrain;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.dags.noise.util.NoiseUtil;

public class Region
implements Extent,
Disposable {
    private final int regionX;
    private final int regionZ;
    private final int chunkX;
    private final int chunkZ;
    private final int blockX;
    private final int blockZ;
    private final int border;
    private final Size blockSize;
    private final Size chunkSize;
    private final GenCell[] blocks;
    private final GenChunk[] chunks;
    private final int disposableChunks;
    private final Disposable.Listener<Region> disposalListener;
    private final AtomicInteger disposedChunks = new AtomicInteger();

    public Region(int regionX, int regionZ, int size, int borderChunks) {
        this(regionX, regionZ, size, borderChunks, region -> {});
    }

    public Region(int regionX, int regionZ, int size, int borderChunks, Disposable.Listener<Region> disposalListener) {
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.chunkX = regionX << size;
        this.chunkZ = regionZ << size;
        this.blockX = Size.chunkToBlock(this.chunkX);
        this.blockZ = Size.chunkToBlock(this.chunkZ);
        this.border = borderChunks;
        this.chunkSize = Size.chunks(size, borderChunks);
        this.blockSize = Size.blocks(size, borderChunks);
        this.disposalListener = disposalListener;
        this.disposableChunks = this.chunkSize.size * this.chunkSize.size;
        this.blocks = new GenCell[this.blockSize.total * this.blockSize.total];
        this.chunks = new GenChunk[this.chunkSize.total * this.chunkSize.total];
    }

    @Override
    public void dispose() {
        int disposed = this.disposedChunks.incrementAndGet();
        if (disposed < this.disposableChunks) {
            return;
        }
        this.disposalListener.onDispose(this);
    }

    public long getRegionId() {
        return NoiseUtil.seed(this.getRegionX(), this.getRegionZ());
    }

    public int getRegionX() {
        return this.regionX;
    }

    public int getRegionZ() {
        return this.regionZ;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public int getOffsetChunks() {
        return this.border;
    }

    public int getChunkCount() {
        return this.chunks.length;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    public Size getChunkSize() {
        return this.chunkSize;
    }

    public Size getBlockSize() {
        return this.blockSize;
    }

    public Filterable<Terrain> filterable() {
        return new FilterRegion();
    }

    public Cell<Terrain> getCell(int blockX, int blockZ) {
        int relBlockX = this.blockSize.border + this.blockSize.mask(blockX);
        int relBlockZ = this.blockSize.border + this.blockSize.mask(blockZ);
        int index = this.blockSize.indexOf(relBlockX, relBlockZ);
        return this.blocks[index];
    }

    public Cell<Terrain> getRawCell(int blockX, int blockZ) {
        int index = this.blockSize.indexOf(blockX, blockZ);
        return this.blocks[index];
    }

    public ChunkReader getChunk(int chunkX, int chunkZ) {
        int relChunkX = this.chunkSize.border + this.chunkSize.mask(chunkX);
        int relChunkZ = this.chunkSize.border + this.chunkSize.mask(chunkZ);
        int index = this.chunkSize.indexOf(relChunkX, relChunkZ);
        return this.chunks[index];
    }

    public void generate(Consumer<ChunkWriter> consumer) {
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                consumer.accept(chunk);
            }
        }
    }

    public void generateBase(Heightmap heightmap) {
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        float x = chunk.getBlockX() + dx;
                        float z = chunk.getBlockZ() + dz;
                        Cell<Terrain> cell = chunk.genCell(dx, dz);
                        heightmap.applyBase(cell, x, z);
                    }
                }
            }
        }
    }

    public void generateRivers(Heightmap heightmap, RiverRegionList rivers) {
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        float x = chunk.getBlockX() + dx;
                        float z = chunk.getBlockZ() + dz;
                        Cell<Terrain> cell = chunk.genCell(dx, dz);
                        heightmap.applyRivers(cell, x, z, rivers);
                        heightmap.applyClimate(cell, x, z);
                    }
                }
            }
        }
    }

    public void generateZoom(Heightmap heightmap, float offsetX, float offsetZ, float zoom) {
        float translateX = offsetX - (float)this.blockSize.size * zoom / 2.0f;
        float translateZ = offsetZ - (float)this.blockSize.size * zoom / 2.0f;
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        float x = (float)(chunk.getBlockX() + dx) * zoom + translateX;
                        float z = (float)(chunk.getBlockZ() + dz) * zoom + translateZ;
                        Cell<Terrain> cell = chunk.genCell(dx, dz);
                        heightmap.apply(cell, x, z);
                    }
                }
            }
        }
    }

    public void decorate(Collection<Decorator> decorators) {
        for (int dz = 0; dz < this.blockSize.total; ++dz) {
            for (int dx = 0; dx < this.blockSize.total; ++dx) {
                int index = this.blockSize.indexOf(dx, dz);
                GenCell cell = this.blocks[index];
                for (Decorator decorator : decorators) {
                    if (decorator.apply(cell, this.getBlockX() + dx, this.getBlockZ() + dz)) break;
                }
            }
        }
    }

    public void decorateZoom(Collection<Decorator> decorators, float offsetX, float offsetZ, float zoom) {
        float translateX = offsetX - (float)this.blockSize.size * zoom / 2.0f;
        float translateZ = offsetZ - (float)this.blockSize.size * zoom / 2.0f;
        for (int cz = 0; cz < this.chunkSize.total; ++cz) {
            for (int cx = 0; cx < this.chunkSize.total; ++cx) {
                int index = this.chunkSize.indexOf(cx, cz);
                GenChunk chunk = this.computeChunk(index, cx, cz);
                chunk.iterate((Cell<Terrain> cell, int dx, int dz) -> {
                    float x = (float)(chunk.getBlockX() + dx) * zoom + translateX;
                    float z = (float)(chunk.getBlockZ() + dz) * zoom + translateZ;
                    for (Decorator decorator : decorators) {
                        decorator.apply(cell, x, z);
                    }
                });
            }
        }
    }

    public void iterate(Consumer<ChunkReader> consumer) {
        for (int cz = 0; cz < this.chunkSize.size; ++cz) {
            int chunkZ = this.chunkSize.border + cz;
            for (int cx = 0; cx < this.chunkSize.size; ++cx) {
                int chunkX = this.chunkSize.border + cx;
                int index = this.chunkSize.indexOf(chunkX, chunkZ);
                GenChunk chunk = this.chunks[index];
                consumer.accept(chunk);
            }
        }
    }

    public void iterate(Cell.Visitor<Terrain> visitor) {
        for (int dz = 0; dz < this.blockSize.size; ++dz) {
            int z = this.blockSize.border + dz;
            for (int dx = 0; dx < this.blockSize.size; ++dx) {
                int x = this.blockSize.border + dx;
                int index = this.blockSize.indexOf(x, z);
                GenCell cell = this.blocks[index];
                visitor.visit(cell, dx, dz);
            }
        }
    }

    @Override
    public void visit(int minX, int minZ, int maxX, int maxZ, Cell.Visitor<Terrain> visitor) {
        int regionMinX = this.getBlockX();
        int regionMinZ = this.getBlockZ();
        if (maxX < regionMinX || maxZ < regionMinZ) {
            return;
        }
        int regionMaxX = this.getBlockX() + this.getBlockSize().size - 1;
        int regionMaxZ = this.getBlockZ() + this.getBlockSize().size - 1;
        if (minX > regionMaxX || maxZ > regionMaxZ) {
            return;
        }
        minX = Math.max(minX, regionMinX);
        minZ = Math.max(minZ, regionMinZ);
        maxX = Math.min(maxX, regionMaxX);
        maxZ = Math.min(maxZ, regionMaxZ);
        for (int z = minZ; z <= maxX; ++z) {
            for (int x = minX; x <= maxZ; ++x) {
                visitor.visit(this.getCell(x, z), x, z);
            }
        }
    }

    private GenChunk computeChunk(int index, int chunkX, int chunkZ) {
        GenChunk chunk = this.chunks[index];
        if (chunk == null) {
            this.chunks[index] = chunk = new GenChunk(chunkX, chunkZ);
        }
        return chunk;
    }

    private GenCell computeCell(int index) {
        GenCell cell = this.blocks[index];
        if (cell == null) {
            this.blocks[index] = cell = new GenCell();
        }
        return cell;
    }

    private class FilterRegion
    implements Filterable<Terrain> {
        private FilterRegion() {
        }

        @Override
        public Size getSize() {
            return Region.this.blockSize;
        }

        @Override
        public Cell<Terrain>[] getBacking() {
            return Region.this.blocks;
        }

        @Override
        public Cell<Terrain> getCellRaw(int x, int z) {
            int index = Region.this.blockSize.indexOf(x, z);
            if (index < 0 || index >= Region.this.blocks.length) {
                return Cell.empty();
            }
            return Region.this.blocks[index];
        }
    }

    private class GenChunk
    implements ChunkReader,
    ChunkWriter {
        private final int chunkX;
        private final int chunkZ;
        private final int blockX;
        private final int blockZ;
        private final int regionBlockX;
        private final int regionBlockZ;

        private GenChunk(int regionChunkX, int regionChunkZ) {
            this.regionBlockX = regionChunkX << 4;
            this.regionBlockZ = regionChunkZ << 4;
            this.chunkX = Region.this.chunkX + regionChunkX - Region.this.getOffsetChunks();
            this.chunkZ = Region.this.chunkZ + regionChunkZ - Region.this.getOffsetChunks();
            this.blockX = this.chunkX << 4;
            this.blockZ = this.chunkZ << 4;
        }

        @Override
        public int getChunkX() {
            return this.chunkX;
        }

        @Override
        public int getChunkZ() {
            return this.chunkZ;
        }

        @Override
        public int getBlockX() {
            return this.blockX;
        }

        @Override
        public int getBlockZ() {
            return this.blockZ;
        }

        @Override
        public void dispose() {
            Region.this.dispose();
        }

        @Override
        public Cell<Terrain> getCell(int blockX, int blockZ) {
            int relX = this.regionBlockX + (blockX & 0xF);
            int relZ = this.regionBlockZ + (blockZ & 0xF);
            int index = Region.this.blockSize.indexOf(relX, relZ);
            return Region.this.blocks[index];
        }

        @Override
        public Cell<Terrain> genCell(int blockX, int blockZ) {
            int relX = this.regionBlockX + (blockX & 0xF);
            int relZ = this.regionBlockZ + (blockZ & 0xF);
            int index = Region.this.blockSize.indexOf(relX, relZ);
            return Region.this.computeCell(index);
        }
    }

    private static class GenCell
    extends Cell<Terrain> {
        private GenCell() {
        }
    }
}

