/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.caelus.api.CaelusAPI;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurio;

public class CurioElytra
implements ICurio {
    public static final AttributeModifier ELYTRA_CURIO_MODIFIER = new AttributeModifier(UUID.fromString("c754faef-9926-4a77-abbe-e34ef0d735aa"), "Elytra curio modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private ItemStack stack;

    public CurioElytra(ItemStack stack) {
        this.stack = stack;
    }

    public void onCurioTick(String identifier, int index, LivingEntity entityLivingBase) {
        if (entityLivingBase.field_70170_p.field_72995_K || !ElytraItem.func_185069_d((ItemStack)this.stack)) {
            return;
        }
        Integer ticksFlying = (Integer)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)entityLivingBase, (String)"field_184629_bo");
        if (ticksFlying != null && (ticksFlying + 1) % 20 == 0) {
            this.stack.func_222118_a(1, entityLivingBase, entity -> entity.func_213361_c(EquipmentSlotType.CHEST));
        }
    }

    public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
        return !(entityLivingBase.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ElytraItem) && !CuriosAPI.getCurioEquipped((Item)Items.field_185160_cR, (LivingEntity)entityLivingBase).isPresent();
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
        IAttributeInstance attributeInstance = entityLivingBase.func_110148_a(CaelusAPI.ELYTRA_FLIGHT);
        if (!attributeInstance.func_180374_a(ELYTRA_CURIO_MODIFIER) && ElytraItem.func_185069_d((ItemStack)this.stack)) {
            attributeInstance.func_111121_a(ELYTRA_CURIO_MODIFIER);
        }
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
        entityLivingBase.func_110148_a(CaelusAPI.ELYTRA_FLIGHT).func_111124_b(ELYTRA_CURIO_MODIFIER);
    }

    public void playEquipSound(LivingEntity entityLivingBase) {
        entityLivingBase.field_70170_p.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_191258_p, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean canRightClickEquip() {
        return true;
    }
}

