/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.silentchaos512.gear.world.placement.NetherFloorWithExtraConfig;

public class NetherFloorWithExtra
extends Placement<NetherFloorWithExtraConfig> {
    private static final int TRACE_DEPTH = 32;

    public NetherFloorWithExtra(Function<Dynamic<?>, ? extends NetherFloorWithExtraConfig> p_i51371_1_) {
        super(p_i51371_1_);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, NetherFloorWithExtraConfig config, BlockPos pos) {
        int count = config.field_202478_a;
        if (random.nextFloat() < config.field_202479_b) {
            count += config.field_202480_c;
        }
        int height = random.nextInt(config.maxHeight - config.minHeight + 1) + config.minHeight;
        return IntStream.range(0, count).mapToObj(p_215051_3_ -> {
            BlockPos pos1 = new BlockPos(pos.func_177958_n() + random.nextInt(16), height, pos.func_177952_p() + random.nextInt(16));
            return NetherFloorWithExtra.findFloor((IWorldReader)world, pos1);
        }).filter(Objects::nonNull);
    }

    @Nullable
    private static BlockPos findFloor(IWorldReader world, BlockPos start) {
        BlockPos pos;
        for (int i = 0; i < 32 && (pos = start.func_177979_c(i)).func_177956_o() >= 0; ++i) {
            if (!world.func_175623_d(pos) || world.func_180495_p(pos.func_177979_c(1)).func_177230_c() != Blocks.field_150424_aL) continue;
            return pos;
        }
        return null;
    }
}

