/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;

public final class ShapedGearRecipe
extends ExtendedShapedRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("shaped_gear_crafting");
    public static final ExtendedShapedRecipe.Serializer<ShapedGearRecipe> SERIALIZER = ExtendedShapedRecipe.Serializer.basic(ShapedGearRecipe::new);
    private final ICoreItem item;

    private ShapedGearRecipe(ShapedRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.func_77973_b();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.getBaseRecipe().func_77569_a(inv, worldIn)) {
            return false;
        }
        GearType gearType = this.item.getGearType();
        return ShapedGearRecipe.getParts((IInventory)inv).stream().allMatch(part -> part.getPart().isCraftingAllowed(gearType));
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.item.construct(ShapedGearRecipe.getParts((IInventory)inv));
    }

    private static Collection<PartData> getParts(IInventory inv) {
        return StackList.from((IInventory)inv).stream().map(PartData::from).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ItemStack func_77571_b() {
        ItemStack result = this.item.construct(GearHelper.getExamplePartsFromRecipe((Iterable<Ingredient>)this.func_192400_c()));
        GearData.setExampleTag(result, true);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }
}

