/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.traits.TraitManager;

public final class SGearTraitsCommand {
    private static final SuggestionProvider<CommandSource> TRAIT_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(TraitManager.getValues().stream().map(ITrait::getId), (SuggestionsBuilder)builder);

    private SGearTraitsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sgear_traits").then(Commands.func_197057_a((String)"describe").then(Commands.func_197056_a((String)"traitID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(TRAIT_ID_SUGGESTIONS).executes(context -> SGearTraitsCommand.runDescribe((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"traitID")))))).then(Commands.func_197057_a((String)"list").executes(SGearTraitsCommand::runList));
        dispatcher.register(builder);
    }

    private static int runDescribe(CommandContext<CommandSource> context, ResourceLocation traitId) {
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentgear.traits.traitNotFound", new Object[]{traitId}));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a(trait.getDisplayName(0), true);
        ((CommandSource)context.getSource()).func_197030_a(trait.getDescription(1), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.silentgear.traits.maxLevel", new Object[]{trait.getMaxLevel()}), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Object: " + trait), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Serializer: " + trait.getSerializer()), true);
        return 1;
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = TraitManager.getValues().stream().map(trait -> trait.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Total: " + TraitManager.getValues().size()), true);
        return 1;
    }

    private static int runMakeWiki(CommandContext<CommandSource> context) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(TraitManager.getKeys());
        ids.sort(Comparator.comparing(id -> TraitManager.get(id).getDisplayName(0).func_150254_d()));
        for (ResourceLocation id2 : ids) {
            ITrait trait = TraitManager.get(id2);
            assert (trait != null);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("### " + trait.getDisplayName(0).func_150254_d()), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("- `" + id2 + "`"), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("- Max Level: " + trait.getMaxLevel()), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("- " + trait.getDescription(1)), true);
        }
        return 1;
    }
}

