/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.detail.ModResources;

public class BlockLinkRelaySwitch
extends BlockSwitch {
    public BlockLinkRelaySwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockLinkRelaySwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    protected void neighborUpdated(BlockState state, World world, BlockPos pos, BlockPos facingPos) {
        boolean powered;
        if (!this.isAffectedByNeigbour(state, (IWorld)world, pos, facingPos)) {
            return;
        }
        BlockSwitch.TileEntitySwitch te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return;
        }
        if (this.isCube()) {
            powered = world.func_175640_z(pos);
        } else {
            Direction facing = ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d();
            BlockPos neighbour_pos = pos.func_177972_a(facing);
            BlockState neighbour_state = world.func_180495_p(neighbour_pos);
            if (!state.func_185897_m()) {
                powered = world.func_175640_z(neighbour_pos);
            } else {
                boolean bl = powered = neighbour_state.func_185911_a((IBlockReader)world, neighbour_pos, facing) > 0 || neighbour_state.func_185893_b((IBlockReader)world, neighbour_pos, facing) > 0;
            }
        }
        if ((this.config & 0x100000L) != 0L && te.inverted()) {
            powered = !powered;
        }
        if (te.on_power() == 0 == powered) {
            return;
        }
        te.on_power(powered ? 0 : 15);
        if ((this.config & 0x10000000L) != 0L && (Boolean)state.func_177229_b((IProperty)POWERED) == powered) {
            return;
        }
        if ((this.config & 0x20000000L) != 0L && (!powered || ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue())) {
            return;
        }
        this.onSwitchActivated(world, pos, state, null, null);
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }
}

