/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.network;

import com.maciej916.maenchants.capabilities.IEnchants;
import com.maciej916.maenchants.utils.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketLumberjackToggle {
    private final boolean toggle;

    public PacketLumberjackToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public PacketLumberjackToggle(PacketBuffer buf) {
        this.toggle = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.toggle);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ctx.get() == null || ((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            IEnchants enchantsCap = PlayerUtil.getEnchantsCapability((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
            enchantsCap.setExcavateActive(this.toggle);
        });
        ctx.get().setPacketHandled(true);
    }
}

