/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork;

import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.block.cable.export.BlockCableExport;
import com.lothrazar.storagenetwork.block.cable.export.ContainerCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.export.TileCableExport;
import com.lothrazar.storagenetwork.block.cable.input.BlockCableIO;
import com.lothrazar.storagenetwork.block.cable.input.TileCableIO;
import com.lothrazar.storagenetwork.block.cable.inputfilter.BlockCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.ContainerCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.TileCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.storagefilter.BlockCableFilter;
import com.lothrazar.storagenetwork.block.cable.storagefilter.ContainerCableFilter;
import com.lothrazar.storagenetwork.block.cable.storagefilter.TileCableFilter;
import com.lothrazar.storagenetwork.block.cablelink.BlockCableLink;
import com.lothrazar.storagenetwork.block.cablelink.TileCableLink;
import com.lothrazar.storagenetwork.block.inventory.BlockInventory;
import com.lothrazar.storagenetwork.block.inventory.ContainerNetworkInventory;
import com.lothrazar.storagenetwork.block.inventory.TileInventory;
import com.lothrazar.storagenetwork.block.master.BlockMaster;
import com.lothrazar.storagenetwork.block.master.TileMaster;
import com.lothrazar.storagenetwork.block.request.BlockRequest;
import com.lothrazar.storagenetwork.block.request.ContainerNetworkCraftingTable;
import com.lothrazar.storagenetwork.block.request.TileRequest;
import com.lothrazar.storagenetwork.capabilities.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.config.ConfigManager;
import com.lothrazar.storagenetwork.item.ItemUpgrade;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.item.remote.ItemRemote;
import com.lothrazar.storagenetwork.jei.JeiSettings;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.setup.ClientProxy;
import com.lothrazar.storagenetwork.setup.IProxy;
import com.lothrazar.storagenetwork.setup.ServerProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="storagenetwork")
public class StorageNetwork {
    public static final String MODID = "storagenetwork";
    static final String certificateFingerprint = "@FINGERPRINT@";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static ConfigManager config;

    public StorageNetwork() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StorageNetwork::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RegistryEvents());
    }

    private static void setup(FMLCommonSetupEvent event) {
        PacketRegistry.init();
        StorageNetworkCapabilities.initCapabilities();
        proxy.init();
        config = new ConfigManager(FMLPaths.CONFIGDIR.get().resolve("storagenetwork.toml"));
        JeiSettings.setJeiLoaded(true);
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
    }

    public static void log(String s) {
        if (config.logspam()) {
            LOGGER.info(s);
        }
    }

    @SubscribeEvent
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "Storage Network: Invalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        System.out.println(msg);
    }

    public static void chatMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(message, new Object[0]));
        }
    }

    public static void statusMessage(PlayerEntity player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(message, new Object[0]), true);
        }
    }

    public static String lang(String message) {
        TranslationTextComponent t = new TranslationTextComponent(message, new Object[0]);
        return t.func_150254_d();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry r = event.getRegistry();
            r.register((IForgeRegistryEntry)new BlockMaster());
            r.register((IForgeRegistryEntry)new BlockRequest());
            r.register((IForgeRegistryEntry)new BlockCable("kabel"));
            r.register((IForgeRegistryEntry)new BlockCableLink("storage_kabel"));
            r.register((IForgeRegistryEntry)new BlockCableIO("import_kabel"));
            r.register((IForgeRegistryEntry)new BlockCableImportFilter("import_filter_kabel"));
            r.register((IForgeRegistryEntry)new BlockCableFilter("filter_kabel"));
            r.register((IForgeRegistryEntry)new BlockCableExport("export_kabel"));
            r.register((IForgeRegistryEntry)new BlockInventory("inventory"));
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().func_200916_a(SsnRegistry.itemGroup);
            IForgeRegistry r = event.getRegistry();
            r.register(new BlockItem(SsnRegistry.inventory, properties).setRegistryName("inventory"));
            r.register(new BlockItem((Block)SsnRegistry.master, properties).setRegistryName("master"));
            r.register(new BlockItem((Block)SsnRegistry.request, properties).setRegistryName("request"));
            r.register(new BlockItem((Block)SsnRegistry.kabel, properties).setRegistryName("kabel"));
            r.register(new BlockItem(SsnRegistry.storagekabel, properties).setRegistryName("storage_kabel"));
            r.register(new BlockItem(SsnRegistry.importkabel, properties).setRegistryName("import_kabel"));
            r.register(new BlockItem(SsnRegistry.importfilterkabel, properties).setRegistryName("import_filter_kabel"));
            r.register(new BlockItem(SsnRegistry.filterkabel, properties).setRegistryName("filter_kabel"));
            r.register(new BlockItem(SsnRegistry.exportkabel, properties).setRegistryName("export_kabel"));
            r.register(new ItemUpgrade(properties).setRegistryName("stack_upgrade"));
            r.register(new ItemUpgrade(properties).setRegistryName("speed_upgrade"));
            r.register(new ItemRemote(properties).setRegistryName("inventory_remote"));
            r.register(new ItemRemote(properties).setRegistryName("crafting_remote"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            IForgeRegistry r = event.getRegistry();
            r.register(TileEntityType.Builder.func_223042_a(TileMaster::new, (Block[])new Block[]{SsnRegistry.master}).func_206865_a(null).setRegistryName("master"));
            r.register(TileEntityType.Builder.func_223042_a(TileInventory::new, (Block[])new Block[]{SsnRegistry.inventory}).func_206865_a(null).setRegistryName("inventory"));
            r.register(TileEntityType.Builder.func_223042_a(TileRequest::new, (Block[])new Block[]{SsnRegistry.request}).func_206865_a(null).setRegistryName("request"));
            r.register(TileEntityType.Builder.func_223042_a(TileCable::new, (Block[])new Block[]{SsnRegistry.kabel}).func_206865_a(null).setRegistryName("kabel"));
            r.register(TileEntityType.Builder.func_223042_a(TileCableLink::new, (Block[])new Block[]{SsnRegistry.storagekabel}).func_206865_a(null).setRegistryName("storage_kabel"));
            r.register(TileEntityType.Builder.func_223042_a(TileCableIO::new, (Block[])new Block[]{SsnRegistry.importkabel}).func_206865_a(null).setRegistryName("import_kabel"));
            r.register(TileEntityType.Builder.func_223042_a(TileCableImportFilter::new, (Block[])new Block[]{SsnRegistry.importfilterkabel}).func_206865_a(null).setRegistryName("import_filter_kabel"));
            r.register(TileEntityType.Builder.func_223042_a(TileCableFilter::new, (Block[])new Block[]{SsnRegistry.filterkabel}).func_206865_a(null).setRegistryName("filter_kabel"));
            r.register(TileEntityType.Builder.func_223042_a(TileCableExport::new, (Block[])new Block[]{SsnRegistry.exportkabel}).func_206865_a(null).setRegistryName("export_kabel"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            IForgeRegistry r = event.getRegistry();
            r.register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerNetworkCraftingTable(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("request"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerCableFilter(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("filter_kabel"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerCableImportFilter(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("import_filter_kabel"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerCableExportFilter(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("export_kabel"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerNetworkInventory(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("inventory"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> new ContainerNetworkRemote(windowId, StorageNetwork.proxy.getClientPlayer().field_71071_by)).setRegistryName("inventory_remote"));
            r.register(IForgeContainerType.create((windowId, inv, data) -> new ContainerNetworkCraftingRemote(windowId, StorageNetwork.proxy.getClientPlayer().field_71071_by)).setRegistryName("crafting_remote"));
        }
    }
}

