/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.block;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractEnergyBlock;
import owmii.lib.block.AbstractEnergyProviderBlock;
import owmii.lib.block.AbstractMachineBlock;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.config.IEnergyProviderConfig;
import owmii.lib.energy.Energy;
import owmii.lib.energy.IRedstoneInteract;
import owmii.lib.energy.Redstone;
import owmii.lib.energy.SideConfig;
import owmii.lib.inventory.Inventory;
import owmii.lib.util.IVariant;
import owmii.lib.util.Safe;
import owmii.lib.util.Server;
import owmii.lib.util.Stack;
import owmii.lib.util.Text;

public class TileBase<E extends IVariant, B extends AbstractBlock<E>>
extends TileEntity {
    protected final Inventory inv = Inventory.createBlank(this);
    private final LazyOptional<Inventory> holder = LazyOptional.of(() -> this.inv);
    protected E variant;
    protected boolean isContainerOpen;
    public boolean isNew = true;
    @Nullable
    public ITextComponent customName;
    public String publicName = "";

    public TileBase(TileEntityType<?> tileEntityTypeIn) {
        this(tileEntityTypeIn, IVariant.getEmpty());
    }

    public TileBase(TileEntityType<?> tileEntityType, E variant) {
        super(tileEntityType);
        this.variant = variant;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readSync(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        return this.writeSync(nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSync(pkt.func_148857_g());
    }

    public void readSync(CompoundNBT compound) {
        this.isNew = compound.func_74767_n("IsNew");
        if (!this.variant.isEmpty() && compound.func_150297_b("Variant", 3)) {
            this.variant = (IVariant)this.variant.read(compound, "Variant");
        }
        if (compound.func_150297_b("DefaultName", 8)) {
            this.publicName = compound.func_74779_i("DefaultName");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
        if (!this.keepInventory()) {
            this.inv.deserializeNBT(compound);
        }
        this.readStorable(compound);
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("IsNew", this.isNew);
        if (!this.variant.isEmpty()) {
            this.variant.write(compound, (Enum)((Enum)this.variant), "Variant");
        }
        if (!this.publicName.isEmpty()) {
            compound.func_74778_a("DefaultName", this.publicName);
        }
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        if (!this.keepInventory()) {
            compound.func_197643_a(this.inv.serializeNBT());
        }
        this.writeStorable(compound);
        return compound;
    }

    public void readStorable(CompoundNBT compound) {
        if (this.keepInventory()) {
            this.inv.deserializeNBT(compound);
        }
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        if (this.keepInventory()) {
            compound.func_197643_a(this.inv.serializeNBT());
        }
        return compound;
    }

    public boolean isNBTStorable() {
        return true;
    }

    public void markDirtyAndSync() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    public boolean isRemote() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K;
    }

    public B getBlock() {
        return (B)((AbstractBlock)this.func_195044_w().func_177230_c());
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos) {
        return this.field_145850_b == null ? null : this.field_145850_b.func_175625_s(pos);
    }

    public void onPlaced(World world, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (stack.func_82837_s()) {
            this.setCustomName(stack.func_200301_q());
        } else {
            this.setDefaultName(this.getBlock().func_149739_a());
        }
        CompoundNBT tag = Stack.getTagOrEmpty(stack);
        if (!tag.isEmpty()) {
            this.readStorable(tag.func_74775_l("lollipopTileStorableNBT"));
        }
    }

    public void onAdded(World world, BlockState state, BlockState oldState, boolean isMoving) {
    }

    public void onRemoved(World world, BlockState state, BlockState newState, boolean isMoving) {
        if (!(state.func_177230_c() == newState.func_177230_c() || this.keepInventory() && this.isNBTStorable())) {
            this.getInventory().drop(world, this.field_174879_c);
        }
    }

    public void neighborChanged(World world, BlockState state, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }

    public void setContainerOpen(boolean b) {
        this.isContainerOpen = b;
    }

    public boolean isContainerOpen() {
        return this.isContainerOpen;
    }

    public void onSlotChanged(int index) {
    }

    public boolean canInsert(int index, ItemStack stack) {
        return true;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int index) {
        return 64;
    }

    public boolean keepInventory() {
        return false;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    public E getVariant() {
        return this.variant;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public ITextComponent getDisplayName() {
        return this.getName();
    }

    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent(this.publicName, new Object[0]);
    }

    public void setDefaultName(String publicName) {
        this.publicName = publicName;
    }

    @Nullable
    public ITextComponent getCustomName() {
        return this.customName;
    }

    public ITextComponent getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public void setCustomName(ITextComponent displayName) {
        this.customName = displayName;
    }

    protected boolean switchLitProp(boolean prev, boolean b, boolean or) {
        if (this.field_145850_b != null && ((AbstractBlock)this.getBlock()).hasLitProp() && (prev != b || or)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)AbstractBlock.LIT, (Comparable)Boolean.valueOf(b)), 3);
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && !this.inv.isBlank() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class Tickable<E extends IVariant, B extends AbstractBlock<E>>
    extends TileBase<E, B>
    implements ITickableTileEntity,
    IRedstoneInteract {
        protected Redstone redstone = Redstone.IGNORE;
        protected int syncTicks;
        public int ticks;

        public Tickable(TileEntityType<?> tileEntityType, E variant) {
            super(tileEntityType, variant);
        }

        public Tickable(TileEntityType<?> type) {
            super(type);
        }

        public void func_73660_a() {
            if (this.field_145850_b == null) {
                return;
            }
            if (this.doTicks(this.field_145850_b)) {
                if (this.ticks == 0) {
                    if (this.isNew) {
                        this.absFirstTick(this.field_145850_b);
                    }
                    this.onFirstTick(this.field_145850_b);
                }
                if (this.doPostTicks(this.field_145850_b) && this.postTicks(this.field_145850_b)) {
                    this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
                    this.sync(this.getSyncTicks());
                }
                if (this.isRemote()) {
                    this.clientTicks(this.field_145850_b);
                }
                ++this.ticks;
                if (this.syncTicks > -1) {
                    --this.syncTicks;
                }
                if (this.syncTicks == 0) {
                    this.markDirtyAndSync();
                }
            }
            if (this.isNew) {
                this.isNew = false;
                this.markDirtyAndSync();
            }
        }

        @Override
        public void readSync(CompoundNBT compound) {
            this.redstone = Redstone.values()[compound.func_74762_e("RedstoneMode")];
            super.readSync(compound);
        }

        @Override
        public CompoundNBT writeSync(CompoundNBT compound) {
            compound.func_74768_a("RedstoneMode", this.redstone.ordinal());
            return super.writeSync(compound);
        }

        protected boolean doTicks(World world) {
            return true;
        }

        protected void absFirstTick(World world) {
        }

        protected void onFirstTick(World world) {
        }

        protected boolean postTicks(World world) {
            return false;
        }

        protected boolean doPostTicks(World world) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        protected void clientTicks(World world) {
        }

        public void resetTicks() {
            this.ticks = 0;
        }

        public void sync(int delay) {
            if (this.syncTicks <= 0 || delay < this.syncTicks) {
                this.syncTicks = delay;
            }
        }

        public boolean checkRedstone() {
            boolean power = this.field_145850_b != null && this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
            return Redstone.IGNORE.equals((Object)this.getRedstoneMode()) || power && Redstone.ON.equals((Object)this.getRedstoneMode()) || !power && Redstone.OFF.equals((Object)this.getRedstoneMode());
        }

        @Override
        public Redstone getRedstoneMode() {
            return this.redstone;
        }

        @Override
        public void setRedstone(Redstone redstone) {
            this.redstone = redstone;
        }

        public int getSyncTicks() {
            if (this.isContainerOpen()) {
                if (!this.isRemote() && Server.isSinglePlayer()) {
                    return 1;
                }
                return 3;
            }
            return 50;
        }
    }

    public static class EnergyStorage<E extends IVariant, B extends AbstractEnergyBlock<E>>
    extends Tickable<E, B>
    implements IRedstoneInteract {
        protected final Energy energy = Energy.create(0L);
        protected SideConfig sideConfig = new SideConfig(this);

        public EnergyStorage(TileEntityType<?> tileEntityType, E variant) {
            super(tileEntityType, variant);
            this.inv.add(this.getChargingSlots());
        }

        public EnergyStorage(TileEntityType<?> type) {
            this(type, IVariant.getEmpty());
        }

        @Override
        public void readSync(CompoundNBT compound) {
            this.sideConfig.read(compound);
            if (!this.keepEnergy()) {
                this.energy.readStored(compound);
            }
            super.readSync(compound);
        }

        @Override
        public CompoundNBT writeSync(CompoundNBT compound) {
            this.sideConfig.write(compound);
            if (!this.keepEnergy()) {
                this.energy.writeStored(compound);
            }
            return super.writeSync(compound);
        }

        @Override
        public void readStorable(CompoundNBT compound) {
            if (this.keepEnergy()) {
                this.energy.readStored(compound);
            }
            super.readStorable(compound);
        }

        @Override
        public CompoundNBT writeStorable(CompoundNBT compound) {
            if (this.keepEnergy()) {
                this.energy.writeStored(compound);
            }
            return super.writeStorable(compound);
        }

        public boolean keepEnergy() {
            return false;
        }

        @Override
        protected void onFirstTick(World world) {
            super.onFirstTick(world);
            this.energy.setCapacity(this.defaultEnergyCapacity());
            if (!this.getTransferType().isOutOnly()) {
                this.energy.setMaxReceive(this.defaultTransfer());
            }
            if (!this.getTransferType().isInOnly()) {
                this.energy.setMaxExtract(this.defaultTransfer());
            }
            this.getSideConfig().init();
            this.sync(1);
        }

        @Override
        protected boolean postTicks(World world) {
            return this.extractFromSides() + this.chargeItems() > 0L;
        }

        protected boolean doWorkingTicks(World world) {
            return this.checkRedstone();
        }

        protected boolean doEnergyTransfer() {
            return true;
        }

        protected long extractFromSides() {
            long extracted = 0L;
            for (Direction side : Direction.values()) {
                if (!this.canExtractEnergy(side)) continue;
                long amount = Math.min(this.getMaxEnergyExtract(), this.getEnergyStored());
                long toExtract = Energy.receive(this.getTileEntity(this.field_174879_c.func_177972_a(side)), side, Safe.integer(amount), false);
                extracted += this.extractEnergy(Safe.integer(toExtract), false, side);
            }
            return extracted;
        }

        protected long chargeItems() {
            long extracted = 0L;
            for (ItemStack stack : this.getChargingInv()) {
                extracted += this.chargeItem(stack, this.getMaxEnergyExtract());
            }
            return extracted;
        }

        protected long chargeItem(ItemStack stack, long transfer) {
            if (!stack.func_190926_b()) {
                long amount = Math.min(transfer, this.getEnergyStored());
                int received = Energy.receive(stack, amount, false);
                return this.extractEnergy(received, false, null);
            }
            return 0L;
        }

        @Override
        public int getSlotLimit(int index) {
            if (index < this.builtInSlots()) {
                return 1;
            }
            return super.getSlotLimit(index);
        }

        public int builtInSlots() {
            return this.getChargingSlots();
        }

        public List<ItemStack> getChargingInv() {
            return IntStream.range(0, this.getChargingSlots()).mapToObj(value -> (ItemStack)this.inv.getStacks().get(value)).collect(Collectors.toList());
        }

        public int getChargingSlots() {
            return 0;
        }

        @Override
        public boolean canInsert(int index, ItemStack stack) {
            if (index < this.getChargingSlots()) {
                return Energy.isPresent(stack);
            }
            return true;
        }

        public long receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction side) {
            if (this.canReceiveEnergy(side)) {
                long energyReceived = Math.min(this.getEnergyStorage().getEmpty(), Math.min(this.getMaxEnergyReceive(), (long)maxReceive));
                if (!simulate) {
                    this.produceEnergy(energyReceived);
                    if (energyReceived > 0L) {
                        this.sync(this.getSyncTicks());
                    }
                }
                return energyReceived;
            }
            return 0L;
        }

        public long extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
            if (this.canExtractEnergy(side)) {
                long energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxEnergyExtract(), (long)maxExtract));
                if (!simulate) {
                    this.consumeEnergy(energyExtracted);
                    if (energyExtracted > 0L) {
                        this.sync(this.getSyncTicks());
                    }
                }
                return energyExtracted;
            }
            return 0L;
        }

        public void produceEnergy(long amount) {
            this.getEnergyStorage().produce(amount);
        }

        public void consumeEnergy(long amount) {
            this.getEnergyStorage().consume(amount);
        }

        @Override
        public void onAdded(World world, BlockState state, BlockState oldState, boolean isMoving) {
            super.onAdded(world, state, oldState, isMoving);
            if (state.func_177230_c() != oldState.func_177230_c()) {
                this.getSideConfig().init();
            }
        }

        public boolean canReceiveEnergy(@Nullable Direction side) {
            return this.doEnergyTransfer() && this.getEnergyStorage().canReceive() && (this.sideConfig.getType(side).isIn() || side == null);
        }

        public boolean canExtractEnergy(@Nullable Direction side) {
            return this.doEnergyTransfer() && this.getEnergyStorage().canExtract() && (this.sideConfig.getType(side).isOut() || side == null);
        }

        public long getEnergyCapacity() {
            return this.getEnergyStorage().getCapacity();
        }

        public long getEnergyStored() {
            return this.getEnergyStorage().getStored();
        }

        public long getMaxEnergyExtract() {
            return Math.min(this.energy.getMaxExtract(), this.defaultTransfer());
        }

        public long getMaxEnergyReceive() {
            return Math.min(this.energy.getMaxReceive(), this.defaultTransfer());
        }

        public long defaultEnergyCapacity() {
            return this.getEnergyConfig().getCapacity(this.getVariant());
        }

        public long defaultTransfer() {
            return this.getEnergyConfig().getTransfer(this.getVariant());
        }

        public Energy getEnergyStorage() {
            return this.energy;
        }

        protected IEnergyConfig<E> getEnergyConfig() {
            return ((AbstractEnergyBlock)this.getBlock()).getEnergyConfig();
        }

        public SideConfig getSideConfig() {
            return this.sideConfig;
        }

        public SideConfig.Type getTransferType() {
            return ((AbstractEnergyBlock)this.getBlock()).getTransferType();
        }

        @Override
        public <T> LazyOptional<T> getCapability(Capability<T> cap, final @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY && this.isEnergyPresent(side)) {
                return LazyOptional.of(() -> new Energy(this.getEnergyStorage()){

                    @Override
                    public int extractEnergy(int maxExtract, boolean simulate) {
                        return Safe.integer(this.extractEnergy(maxExtract, simulate, side));
                    }

                    @Override
                    public int receiveEnergy(int maxReceive, boolean simulate) {
                        return Safe.integer(this.receiveEnergy(maxReceive, simulate, side));
                    }

                    @Override
                    public boolean canReceive() {
                        return this.canReceiveEnergy(side);
                    }

                    @Override
                    public boolean canExtract() {
                        return this.canExtractEnergy(side);
                    }
                }).cast();
            }
            return super.getCapability(cap, side);
        }

        public boolean isEnergyPresent(@Nullable Direction side) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void getListedEnergyInfo(List<String> list) {
            TextFormatting g = TextFormatting.GRAY;
            TextFormatting dg = TextFormatting.DARK_GRAY;
            list.add(g + I18n.func_135052_a((String)"info.lollipop.stored.energy.fe", (Object[])new Object[]{dg + Text.addCommas(this.energy.getStored()), Text.numFormat(this.energy.getCapacity())}));
            long ext = this.getMaxEnergyExtract();
            long re = this.getMaxEnergyReceive();
            if (ext + re > 0L) {
                if (ext == re) {
                    list.add(g + I18n.func_135052_a((String)"info.lollipop.max.transfer.fe", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(ext)}));
                } else {
                    if (ext > 0L) {
                        list.add(g + I18n.func_135052_a((String)"info.lollipop.max.extract.fe", (Object[])new Object[]{dg + Text.numFormat(ext)}));
                    }
                    if (re > 0L) {
                        list.add(g + I18n.func_135052_a((String)"info.lollipop.max.receive.fe", (Object[])new Object[]{dg + Text.numFormat(re)}));
                    }
                }
            }
        }
    }

    public static class Machine<E extends IVariant, B extends AbstractMachineBlock<E>>
    extends EnergyStorage<E, B> {
        public Machine(TileEntityType<?> tileEntityType, E variant) {
            super(tileEntityType, variant);
        }

        @Override
        public long getMaxEnergyExtract() {
            return 0L;
        }

        public Machine(TileEntityType<?> type) {
            super(type);
        }
    }

    public static class EnergyProvider<E extends IVariant, B extends AbstractEnergyProviderBlock<E>>
    extends EnergyStorage<E, B> {
        protected long buffer;
        protected long nextBuff;

        public EnergyProvider(TileEntityType<?> tileEntityType, E variant) {
            super(tileEntityType, variant);
        }

        public EnergyProvider(TileEntityType<?> type, long perTick) {
            this(type, IVariant.getEmpty());
        }

        @Override
        public void readSync(CompoundNBT compound) {
            super.readSync(compound);
            if (this.hasEnergyBuffer()) {
                this.buffer = compound.func_74763_f("EnergyBuffer");
                this.nextBuff = compound.func_74763_f("NextEnergyBuff");
            }
        }

        @Override
        public CompoundNBT writeSync(CompoundNBT compound) {
            if (this.hasEnergyBuffer()) {
                compound.func_74772_a("EnergyBuffer", this.buffer);
                compound.func_74772_a("NextEnergyBuff", this.nextBuff);
            }
            return super.writeSync(compound);
        }

        public boolean hasEnergyBuffer() {
            return false;
        }

        @Override
        protected boolean postTicks(World world) {
            if (this.isRemote()) {
                return false;
            }
            boolean flag = this.nextBuff > 0L;
            boolean flag1 = super.postTicks(world);
            if (this.doWorkingTicks(world)) {
                if (this.defaultGeneration() > 0L) {
                    long toGenerate = Math.min(this.defaultGeneration(), this.getEnergyStorage().getEmpty());
                    if (this.nextBuff > toGenerate) {
                        this.nextBuff -= toGenerate;
                        if (this.nextBuff <= 0L) {
                            this.buffer = 0L;
                        }
                    } else {
                        toGenerate = this.nextBuff;
                        this.nextBuff = 0L;
                        this.buffer = 0L;
                    }
                    this.generate(world);
                    if (toGenerate > 0L) {
                        this.produceEnergy(toGenerate);
                        flag1 = true;
                    }
                }
                if (this.switchLitProp(flag, this.nextBuff > 0L, false)) {
                    flag1 = true;
                }
            }
            return flag1;
        }

        protected void generate(World world) {
        }

        public long getBuffer() {
            return this.buffer;
        }

        public long getNextBuff() {
            return this.nextBuff;
        }

        public long getGeneration() {
            return this.defaultGeneration();
        }

        public long defaultGeneration() {
            return this.getEnergyConfig().getGeneration(this.getVariant());
        }

        @Override
        protected IEnergyProviderConfig<E> getEnergyConfig() {
            return ((AbstractEnergyProviderBlock)this.getBlock()).getEnergyConfig();
        }

        @Override
        public long getMaxEnergyReceive() {
            return 0L;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void getListedEnergyInfo(List<String> list) {
            super.getListedEnergyInfo(list);
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.max.generates", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat(this.getGeneration())}));
        }
    }
}

