/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.screen.grid.view;

import com.raoulvdberge.refinedstorage.screen.grid.GridScreen;
import com.raoulvdberge.refinedstorage.screen.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.screen.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.stack.ItemGridStack;
import com.raoulvdberge.refinedstorage.screen.grid.view.BaseGridView;
import java.util.List;

public class ItemGridView
extends BaseGridView {
    public ItemGridView(GridScreen screen, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        super(screen, defaultSorter, sorters);
    }

    @Override
    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            this.map.put(stack.getId(), stack);
        }
    }

    @Override
    public void postChange(IGridStack stack, int delta) {
        ItemGridStack existing;
        if (!(stack instanceof ItemGridStack)) {
            return;
        }
        if (!stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
            IGridStack craftingStack = (IGridStack)this.map.get(stack.getOtherId());
            craftingStack.updateOtherId(stack.getId());
            craftingStack.setTrackerEntry(stack.getTrackerEntry());
        }
        if ((existing = (ItemGridStack)this.map.get(stack.getId())) == null) {
            ((ItemGridStack)stack).getStack().func_190920_e(delta);
            this.map.put(stack.getId(), stack);
        } else {
            if (existing.getStack().func_190916_E() + delta <= 0) {
                existing.setZeroed(true);
                this.map.remove(existing.getId());
            } else {
                existing.getStack().func_190917_f(delta);
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
    }
}

