/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.blockitem;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.ItemStorageType;
import com.raoulvdberge.refinedstorage.block.StorageBlock;
import com.raoulvdberge.refinedstorage.item.StoragePartItem;
import com.raoulvdberge.refinedstorage.item.blockitem.BaseBlockItem;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StorageBlockItem
extends BaseBlockItem {
    private final ItemStorageType type;

    public StorageBlockItem(StorageBlock block) {
        super(block, new Item.Properties().func_200916_a(RS.MAIN_GROUP));
        this.type = block.getType();
        this.setRegistryName(block.getRegistryName());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add(new TranslationTextComponent("misc.refinedstorage.storage.stored", new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).func_150255_a(Styles.GRAY));
                } else {
                    tooltip.add(new TranslationTextComponent("misc.refinedstorage.storage.stored_capacity", new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).func_150255_a(Styles.GRAY));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add(new StringTextComponent(id.toString()).func_150255_a(Styles.GRAY));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack storageStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_213453_ef() && this.type != ItemStorageType.CREATIVE) {
            UUID diskId = null;
            IStorage disk = null;
            if (this.isValid(storageStack)) {
                diskId = this.getId(storageStack);
                disk = API.instance().getStorageDiskManager((ServerWorld)world).get(diskId);
            }
            if (disk == null || disk.getStored() == 0) {
                ItemStack storagePart = new ItemStack((IItemProvider)StoragePartItem.getByType(this.type));
                if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                    InventoryHelper.func_180173_a((World)world, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)storagePart);
                }
                if (disk != null) {
                    API.instance().getStorageDiskManager((ServerWorld)world).remove(diskId);
                    API.instance().getStorageDiskManager((ServerWorld)world).markForSaving();
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)new ItemStack((IItemProvider)RSBlocks.MACHINE_CASING));
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)storageStack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    private UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a("Id");
    }

    private boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b("Id");
    }
}

