/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache.listener;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.network.grid.GridFluidDeltaMessage;
import com.raoulvdberge.refinedstorage.network.grid.GridFluidUpdateMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fluids.FluidStack;

public class FluidGridStorageCacheListener
implements IStorageCacheListener<FluidStack> {
    private ServerPlayerEntity player;
    private INetwork network;

    public FluidGridStorageCacheListener(ServerPlayerEntity player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridFluidUpdateMessage(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)this.player)));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<FluidStack> delta) {
        ArrayList<StackListResult<FluidStack>> deltas = new ArrayList<StackListResult<FluidStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<FluidStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<FluidStack>> deltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridFluidDeltaMessage(this.network, deltas));
    }
}

