/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IntegerListListEntry
extends AbstractTextFieldListListEntry<Integer, IntegerListCell, IntegerListListEntry> {
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;

    @Deprecated
    public IntegerListListEntry(String fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public IntegerListListEntry(String fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    public IntegerListListEntry(String fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, String resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, IntegerListCell::new);
    }

    public IntegerListListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public IntegerListListEntry self() {
        return this;
    }

    public static class IntegerListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Integer, IntegerListCell, IntegerListListEntry> {
        public IntegerListCell(Integer value, IntegerListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Integer substituteDefault(@Nullable Integer value) {
            if (value == null) {
                return 0;
            }
            return value;
        }

        @Override
        protected boolean isValidText(String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45);
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.widget.func_146179_b());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                int i = Integer.parseInt(this.widget.func_146179_b());
                if (i > ((IntegerListListEntry)this.listListEntry).maximum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{((IntegerListListEntry)this.listListEntry).maximum}));
                }
                if (i < ((IntegerListListEntry)this.listListEntry).minimum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{((IntegerListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_int", (Object[])new Object[0]));
            }
            return Optional.empty();
        }
    }
}

