/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.ClothConfigInitializer;
import me.shedaniel.forge.clothconfig2.api.ScissorsHandler;
import me.shedaniel.forge.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.forge.math.Rectangle;
import me.shedaniel.forge.math.impl.PointHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DropdownBoxEntry<T>
extends TooltipListEntry<T> {
    protected Button resetButton;
    protected SelectionElement<T> selectionElement;
    private Supplier<T> defaultValue;
    @Nullable
    private Consumer<T> saveConsumer;

    @Deprecated
    public DropdownBoxEntry(String fieldName, String resetButtonKey, @Nullable Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart, @Nullable Supplier<T> defaultValue, @Nullable Consumer<T> saveConsumer, @Nullable Iterable<T> selections, SelectionTopCellElement<T> topRenderer, SelectionCellCreator<T> cellCreator) {
        super(I18n.func_135052_a((String)fieldName, (Object[])new Object[0]), tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.selectionElement.topRenderer.setValue(defaultValue.get());
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.selectionElement = new SelectionElement(this, new Rectangle(0, 0, 150, 20), new DefaultDropdownMenuElement(selections == null ? ImmutableList.of() : ImmutableList.copyOf(selections)), topRenderer, cellCreator);
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && (!this.defaultValue.get().equals(this.getValue()) || this.getConfigError().isPresent());
        this.resetButton.y = y;
        this.selectionElement.active = this.isEditable();
        this.selectionElement.bounds.y = y;
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.selectionElement.bounds.x = x + this.resetButton.getWidth() + 1;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.selectionElement.bounds.x = x + entryWidth - 150 + 1;
        }
        this.selectionElement.bounds.width = 150 - this.resetButton.getWidth() - 4;
        this.resetButton.render(mouseX, mouseY, delta);
        this.selectionElement.render(mouseX, mouseY, delta);
    }

    @Override
    public void updateSelected(boolean isSelected) {
        this.selectionElement.topRenderer.isSelected = isSelected;
        this.selectionElement.menu.isSelected = isSelected;
    }

    public ImmutableList<T> getSelections() {
        return this.selectionElement.menu.getSelections();
    }

    @Override
    public T getValue() {
        return this.selectionElement.getValue();
    }

    @Deprecated
    public SelectionElement<T> getSelectionElement() {
        return this.selectionElement;
    }

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public List<? extends IGuiEventListener> children() {
        return Lists.newArrayList((Object[])new AbstractGui[]{this.selectionElement, this.resetButton});
    }

    @Override
    public Optional<String> getError() {
        return this.selectionElement.topRenderer.getError();
    }

    @Override
    public void lateRender(int mouseX, int mouseY, float delta) {
        this.selectionElement.lateRender(mouseX, mouseY, delta);
    }

    @Override
    public int getMorePossibleHeight() {
        return this.selectionElement.getMorePossibleHeight();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        return this.selectionElement.mouseScrolled(double_1, double_2, double_3);
    }

    public static class DefaultSelectionTopCellElement<R>
    extends SelectionTopCellElement<R> {
        protected TextFieldWidget textFieldWidget;
        protected Function<String, R> toObjectFunction;
        protected Function<R, String> toStringFunction;
        protected R value;

        public DefaultSelectionTopCellElement(R value, Function<String, R> toObjectFunction, Function<R, String> toStringFunction) {
            this.value = Objects.requireNonNull(value);
            this.toObjectFunction = Objects.requireNonNull(toObjectFunction);
            this.toStringFunction = Objects.requireNonNull(toStringFunction);
            this.textFieldWidget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 148, 18, ""){

                public void render(int int_1, int int_2, float float_1) {
                    this.setFocused(isSelected && this.getParent().getFocused() == this.getParent().selectionElement && this.getParent().selectionElement.getFocused() == this && this.getFocused() == this);
                    super.render(int_1, int_2, float_1);
                }

                public boolean keyPressed(int int_1, int int_2, int int_3) {
                    if (int_1 == 257 || int_1 == 335) {
                        this.selectFirstRecommendation();
                        return true;
                    }
                    return super.keyPressed(int_1, int_2, int_3);
                }
            };
            this.textFieldWidget.func_146185_a(false);
            this.textFieldWidget.func_146203_f(999999);
            this.textFieldWidget.func_146180_a(toStringFunction.apply(value));
            this.textFieldWidget.func_212954_a(s -> {
                if (this.getParent() != null && this.getParent().getScreen() != null && !((String)toStringFunction.apply(value)).equals(s)) {
                    this.getParent().getScreen().setEdited(true, this.getParent().isRequiresRestart());
                }
            });
        }

        @Override
        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            this.textFieldWidget.x = x + 4;
            this.textFieldWidget.y = y + 6;
            this.textFieldWidget.setWidth(width - 8);
            this.textFieldWidget.func_146184_c(this.getParent().isEditable());
            this.textFieldWidget.func_146193_g(this.getPreferredTextColor());
            this.textFieldWidget.render(mouseX, mouseY, delta);
        }

        @Override
        public R getValue() {
            if (this.hasConfigError()) {
                return this.value;
            }
            return this.toObjectFunction.apply(this.textFieldWidget.func_146179_b());
        }

        @Override
        public void setValue(R value) {
            this.textFieldWidget.func_146180_a(this.toStringFunction.apply(value));
            this.textFieldWidget.func_146190_e(0);
        }

        @Override
        public String getSearchTerm() {
            return this.textFieldWidget.func_146179_b();
        }

        @Override
        public Optional<String> getError() {
            if (this.toObjectFunction.apply(this.textFieldWidget.func_146179_b()) != null) {
                return Optional.empty();
            }
            return Optional.of("Invalid Value!");
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.singletonList(this.textFieldWidget);
        }
    }

    public static abstract class SelectionTopCellElement<R>
    extends FocusableGui {
        @Deprecated
        private DropdownBoxEntry<R> entry;
        protected boolean isSelected = false;

        public abstract R getValue();

        public abstract void setValue(R var1);

        public abstract String getSearchTerm();

        public abstract Optional<String> getError();

        public final Optional<String> getConfigError() {
            return this.entry.getConfigError();
        }

        public DropdownBoxEntry<R> getParent() {
            return this.entry;
        }

        public final boolean hasConfigError() {
            return this.getConfigError().isPresent();
        }

        public final int getPreferredTextColor() {
            return this.getConfigError().isPresent() ? 0xFF5555 : 0xFFFFFF;
        }

        public void selectFirstRecommendation() {
            List children = this.getParent().selectionElement.menu.children();
            for (SelectionCellElement child : children) {
                if (child.getSelection() == null) continue;
                this.setValue(child.getSelection());
                this.getParent().selectionElement.setFocused(null);
                break;
            }
        }

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, float var7);
    }

    public static class DefaultSelectionCellElement<R>
    extends SelectionCellElement<R> {
        protected R r;
        protected int x;
        protected int y;
        protected int width;
        protected int height;
        protected boolean rendering;
        protected Function<R, String> toStringFunction;

        public DefaultSelectionCellElement(R r, Function<R, String> toStringFunction) {
            this.r = r;
            this.toStringFunction = toStringFunction;
        }

        @Override
        public void render(int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
            boolean b;
            this.rendering = true;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
            if (b) {
                DefaultSelectionCellElement.fill((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-15132391);
            }
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.toStringFunction.apply(this.r), (float)(x + 6), (float)(y + 3), b ? 0xFFFFFF : 0x888888);
        }

        @Override
        public void dontRender(float delta) {
            this.rendering = false;
        }

        @Override
        @Nullable
        public String getSearchKey() {
            return this.toStringFunction.apply(this.r);
        }

        @Override
        @Nullable
        public R getSelection() {
            return this.r;
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.emptyList();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
            boolean b;
            boolean bl = b = this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
            if (b) {
                this.getEntry().selectionElement.topRenderer.setValue(this.r);
                this.getEntry().selectionElement.setFocused(null);
                this.getEntry().selectionElement.dontReFocus = true;
                return true;
            }
            return false;
        }
    }

    public static abstract class SelectionCellElement<R>
    extends FocusableGui {
        @Deprecated
        private DropdownBoxEntry<R> entry;

        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, float var7);

        public abstract void dontRender(float var1);

        @Nullable
        public abstract String getSearchKey();

        @Nullable
        public abstract R getSelection();
    }

    public static class DefaultSelectionCellCreator<R>
    extends SelectionCellCreator<R> {
        protected Function<R, String> toStringFunction;

        public DefaultSelectionCellCreator(Function<R, String> toStringFunction) {
            this.toStringFunction = toStringFunction;
        }

        public DefaultSelectionCellCreator() {
            this(Object::toString);
        }

        @Override
        public SelectionCellElement<R> create(R selection) {
            return new DefaultSelectionCellElement<R>(selection, this.toStringFunction);
        }

        @Override
        public int getCellHeight() {
            return 14;
        }

        @Override
        public int getDropBoxMaxHeight() {
            return this.getCellHeight() * 7;
        }
    }

    public static abstract class SelectionCellCreator<R> {
        public abstract SelectionCellElement<R> create(R var1);

        public abstract int getCellHeight();

        public abstract int getDropBoxMaxHeight();

        public int getCellWidth() {
            return 132;
        }
    }

    public static class DefaultDropdownMenuElement<R>
    extends DropdownMenuElement<R> {
        protected ImmutableList<R> selections;
        protected List<SelectionCellElement<R>> cells;
        protected List<SelectionCellElement<R>> currentElements;
        protected String lastSearchKeyword = "";
        protected Rectangle lastRectangle;
        protected boolean scrolling;
        protected double scroll;
        protected double target;
        protected long start;
        protected long duration;

        public DefaultDropdownMenuElement(ImmutableList<R> selections) {
            this.selections = selections;
            this.cells = Lists.newArrayList();
            this.currentElements = Lists.newArrayList();
        }

        public double getMaxScroll() {
            return this.getCellCreator().getCellHeight() * this.currentElements.size();
        }

        protected double getMaxScrollPosition() {
            return Math.max(0.0, this.getMaxScroll() - (double)this.getHeight());
        }

        @Override
        public ImmutableList<R> getSelections() {
            return this.selections;
        }

        @Override
        public void initCells() {
            for (Object selection : this.getSelections()) {
                this.cells.add(this.getCellCreator().create(selection));
            }
            for (SelectionCellElement cell : this.cells) {
                cell.entry = this.getEntry();
            }
            this.search();
        }

        public void search() {
            this.currentElements.clear();
            String keyword = this.lastSearchKeyword.toLowerCase();
            for (SelectionCellElement<R> cell : this.cells) {
                String key = cell.getSearchKey();
                if (key != null && !key.toLowerCase().contains(keyword)) continue;
                this.currentElements.add(cell);
            }
            if (!keyword.isEmpty()) {
                Comparator<SelectionCellElement> c = Comparator.comparingDouble(i -> i.getSearchKey() == null ? Double.MAX_VALUE : this.similarity(i.getSearchKey(), keyword));
                this.currentElements.sort(c.reversed());
            }
            this.scrollTo(0.0, false);
        }

        protected int editDistance(String s1, String s2) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            int[] costs = new int[s2.length() + 1];
            for (int i = 0; i <= s1.length(); ++i) {
                int lastValue = i;
                for (int j = 0; j <= s2.length(); ++j) {
                    if (i == 0) {
                        costs[j] = j;
                        continue;
                    }
                    if (j <= 0) continue;
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                if (i <= 0) continue;
                costs[s2.length()] = lastValue;
            }
            return costs[s2.length()];
        }

        protected double similarity(String s1, String s2) {
            int longerLength;
            String longer = s1;
            String shorter = s2;
            if (s1.length() < s2.length()) {
                longer = s2;
                shorter = s1;
            }
            if ((longerLength = longer.length()) == 0) {
                return 1.0;
            }
            return (double)(longerLength - this.editDistance(longer, shorter)) / (double)longerLength;
        }

        @Override
        public void render(int mouseX, int mouseY, Rectangle rectangle, float delta) {
            if (!this.getEntry().selectionElement.topRenderer.getSearchTerm().equals(this.lastSearchKeyword)) {
                this.lastSearchKeyword = this.getEntry().selectionElement.topRenderer.getSearchTerm();
                this.search();
            }
            this.updatePosition(delta);
            this.lastRectangle = rectangle.clone();
            this.lastRectangle.translate(0, -1);
        }

        private void updatePosition(float delta) {
            double[] target = new double[]{this.target};
            this.scroll = ClothConfigInitializer.handleScrollingPosition(target, this.scroll, this.getMaxScroll(), delta, this.start, this.duration);
            this.target = target[0];
        }

        @Override
        public void lateRender(int mouseX, int mouseY, float delta) {
            int last10Height = this.getHeight();
            int cWidth = this.getCellCreator().getCellWidth();
            DefaultDropdownMenuElement.fill((int)this.lastRectangle.x, (int)(this.lastRectangle.y + this.lastRectangle.height), (int)(this.lastRectangle.x + cWidth), (int)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1), (int)-6250336);
            DefaultDropdownMenuElement.fill((int)(this.lastRectangle.x + 1), (int)(this.lastRectangle.y + this.lastRectangle.height + 1), (int)(this.lastRectangle.x + cWidth - 1), (int)(this.lastRectangle.y + this.lastRectangle.height + last10Height), (int)-16777216);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)300.0f);
            ScissorsHandler.INSTANCE.scissor(new Rectangle(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height + 1, cWidth - 6, last10Height - 1));
            double yy = (double)(this.lastRectangle.y + this.lastRectangle.height) - this.scroll;
            for (SelectionCellElement<R> cell : this.currentElements) {
                if (yy + (double)this.getCellCreator().getCellHeight() >= (double)(this.lastRectangle.y + this.lastRectangle.height) && yy <= (double)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1)) {
                    cell.render(mouseX, mouseY, this.lastRectangle.x, (int)yy, this.getMaxScrollPosition() > 6.0 ? this.getCellCreator().getCellWidth() - 6 : this.getCellCreator().getCellWidth(), this.getCellCreator().getCellHeight(), delta);
                } else {
                    cell.dontRender(delta);
                }
                yy += (double)this.getCellCreator().getCellHeight();
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.currentElements.isEmpty()) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                String s = I18n.func_135052_a((String)"text.cloth-config.dropdown.value.unknown", (Object[])new Object[0]);
                fontRenderer.func_175063_a(s, (float)this.lastRectangle.x + (float)this.getCellCreator().getCellWidth() / 2.0f - (float)fontRenderer.func_78256_a(s) / 2.0f, (float)(this.lastRectangle.y + this.lastRectangle.height + 3), -1);
            }
            if (this.getMaxScrollPosition() > 6.0) {
                RenderSystem.disableTexture();
                int scrollbarPositionMinX = this.lastRectangle.x + this.getCellCreator().getCellWidth() - 6;
                int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
                int height = (int)((double)(last10Height * last10Height) / this.getMaxScrollPosition());
                height = MathHelper.func_76125_a((int)height, (int)32, (int)(last10Height - 8));
                height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > this.getMaxScrollPosition() ? (double)((int)this.scroll) - this.getMaxScrollPosition() : 0.0), (double)height * 0.95));
                height = Math.max(10, height);
                int minY = (int)Math.min(Math.max((double)((int)this.scroll * (last10Height - height)) / this.getMaxScrollPosition() + (double)(this.lastRectangle.y + this.lastRectangle.height + 1), (double)(this.lastRectangle.y + this.lastRectangle.height + 1)), (double)(this.lastRectangle.y + this.lastRectangle.height + 1 + last10Height - height));
                int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
                int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_225582_a_((double)scrollbarPositionMinX, (double)(minY + height), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)minY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollbarPositionMinX, (double)minY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(bottomc, bottomc, bottomc, 255).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_225582_a_((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollbarPositionMinX, (double)minY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(topc, topc, topc, 255).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-300.0f);
            RenderSystem.popMatrix();
        }

        @Override
        public int getHeight() {
            return Math.max(Math.min(this.getCellCreator().getDropBoxMaxHeight(), (int)this.getMaxScroll()), 14);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.isExpanded() && mouseX >= (double)this.lastRectangle.x && mouseX <= (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth()) && mouseY >= (double)(this.lastRectangle.y + this.lastRectangle.height) && mouseY <= (double)(this.lastRectangle.y + this.lastRectangle.height + this.getHeight() + 1);
        }

        public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!this.isExpanded()) {
                return false;
            }
            if (int_1 == 0 && this.scrolling) {
                if (double_2 < (double)this.lastRectangle.y + (double)this.lastRectangle.height) {
                    this.scrollTo(0.0, false);
                } else if (double_2 > (double)this.lastRectangle.y + (double)this.lastRectangle.height + (double)this.getHeight()) {
                    this.scrollTo(this.getMaxScrollPosition(), false);
                } else {
                    double double_5 = Math.max(1.0, this.getMaxScrollPosition());
                    int int_2 = this.getHeight();
                    int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                    double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                    this.offset(double_4 * double_6, false);
                }
                this.target = MathHelper.func_151237_a((double)this.target, (double)0.0, (double)this.getMaxScrollPosition());
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double double_3) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        protected void updateScrollingState(double double_1, double double_2, int int_1) {
            this.scrolling = this.isExpanded() && this.lastRectangle != null && int_1 == 0 && double_1 >= (double)this.lastRectangle.x + (double)this.getCellCreator().getCellWidth() - 6.0 && double_1 < (double)(this.lastRectangle.x + this.getCellCreator().getCellWidth());
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (!this.isExpanded()) {
                return false;
            }
            this.updateScrollingState(double_1, double_2, int_1);
            return super.mouseClicked(double_1, double_2, int_1) || this.scrolling;
        }

        public void offset(double value, boolean animated) {
            this.scrollTo(this.target + value, animated);
        }

        public void scrollTo(double value, boolean animated) {
            this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }

        public void scrollTo(double value, boolean animated, long duration) {
            this.target = ClothConfigInitializer.clamp(value, this.getMaxScrollPosition());
            if (animated) {
                this.start = System.currentTimeMillis();
                this.duration = duration;
            } else {
                this.scroll = this.target;
            }
        }

        @Override
        public List<SelectionCellElement<R>> children() {
            return this.currentElements;
        }
    }

    public static abstract class DropdownMenuElement<R>
    extends FocusableGui {
        @Deprecated
        private SelectionCellCreator<R> cellCreator;
        @Deprecated
        private DropdownBoxEntry<R> entry;
        private boolean isSelected;

        public SelectionCellCreator<R> getCellCreator() {
            return this.cellCreator;
        }

        public final DropdownBoxEntry<R> getEntry() {
            return this.entry;
        }

        public abstract ImmutableList<R> getSelections();

        public abstract void initCells();

        public abstract void render(int var1, int var2, Rectangle var3, float var4);

        public abstract void lateRender(int var1, int var2, float var3);

        public abstract int getHeight();

        public final boolean isExpanded() {
            return this.isSelected && this.getEntry().getFocused() == this.getEntry().selectionElement;
        }

        public abstract List<SelectionCellElement<R>> children();
    }

    public static class SelectionElement<R>
    extends FocusableGui
    implements IRenderable {
        protected Rectangle bounds;
        protected boolean active;
        protected SelectionTopCellElement<R> topRenderer;
        protected DropdownBoxEntry<R> entry;
        protected DropdownMenuElement<R> menu;
        protected boolean dontReFocus = false;

        public SelectionElement(DropdownBoxEntry<R> entry, Rectangle bounds, DropdownMenuElement<R> menu, SelectionTopCellElement<R> topRenderer, SelectionCellCreator<R> cellCreator) {
            this.bounds = bounds;
            this.entry = entry;
            this.menu = Objects.requireNonNull(menu);
            ((DropdownMenuElement)this.menu).entry = entry;
            ((DropdownMenuElement)this.menu).cellCreator = Objects.requireNonNull(cellCreator);
            this.menu.initCells();
            this.topRenderer = Objects.requireNonNull(topRenderer);
            ((SelectionTopCellElement)this.topRenderer).entry = entry;
        }

        public void render(int mouseX, int mouseY, float delta) {
            SelectionElement.fill((int)this.bounds.x, (int)this.bounds.y, (int)(this.bounds.x + this.bounds.width), (int)(this.bounds.y + this.bounds.height), (int)-6250336);
            SelectionElement.fill((int)(this.bounds.x + 1), (int)(this.bounds.y + 1), (int)(this.bounds.x + this.bounds.width - 1), (int)(this.bounds.y + this.bounds.height - 1), (int)-16777216);
            this.topRenderer.render(mouseX, mouseY, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, delta);
            if (this.menu.isExpanded()) {
                this.menu.render(mouseX, mouseY, this.bounds, delta);
            }
        }

        @Deprecated
        public SelectionTopCellElement<R> getTopRenderer() {
            return this.topRenderer;
        }

        public boolean mouseScrolled(double double_1, double double_2, double double_3) {
            if (this.menu.isExpanded()) {
                return this.menu.mouseScrolled(double_1, double_2, double_3);
            }
            return false;
        }

        public void lateRender(int mouseX, int mouseY, float delta) {
            if (this.menu.isExpanded()) {
                this.menu.lateRender(mouseX, mouseY, delta);
            }
        }

        public int getMorePossibleHeight() {
            if (this.menu.isExpanded()) {
                return this.menu.getHeight();
            }
            return -1;
        }

        public R getValue() {
            return this.topRenderer.getValue();
        }

        public List<? extends IGuiEventListener> children() {
            return Lists.newArrayList((Object[])new FocusableGui[]{this.topRenderer, this.menu});
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            this.dontReFocus = false;
            boolean b = super.mouseClicked(double_1, double_2, int_1);
            if (this.dontReFocus) {
                this.setFocused(null);
                this.dontReFocus = false;
            }
            return b;
        }
    }
}

