/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.impl;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.container.BasicContainer;
import com.hrznstudio.titanium.container.IDisableableContainer;
import com.hrznstudio.titanium.container.impl.DisableableSlot;
import java.awt.Point;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;

public class BasicInventoryContainer
extends BasicContainer
implements IDisableableContainer {
    private boolean isDisabled = false;
    private PlayerInventory inventory;
    private boolean hasPlayerInventory;

    public BasicInventoryContainer(int id, PlayerInventory inventory, PacketBuffer buffer) {
        super(id, inventory, buffer);
    }

    public BasicInventoryContainer(ContainerType type, PlayerInventory inventory, int id) {
        super(type, id);
        this.inventory = inventory;
        this.addPlayerChestInventory();
    }

    public BasicInventoryContainer(ContainerType type, PlayerInventory inventory, int id, IAssetProvider assetProvider) {
        super(type, id, assetProvider);
        this.inventory = inventory;
    }

    public void initInventory() {
        this.addExtraSlots();
        this.addPlayerChestInventory();
        this.addHotbarSlots();
    }

    public void addPlayerChestInventory() {
        Point invPos = IAssetProvider.getAsset(this.getAssetProvider(), AssetTypes.BACKGROUND).getInventoryPosition();
        if (!this.hasPlayerInventory) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new DisableableSlot((IInventory)this.inventory, j + i * 9 + 9, invPos.x + j * 18, invPos.y + i * 18, this));
                }
            }
            this.hasPlayerInventory = true;
        }
    }

    public void addHotbarSlots() {
        Point hotbarPos = IAssetProvider.getAsset(this.getAssetProvider(), AssetTypes.BACKGROUND).getHotbarPosition();
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)this.getPlayerInventory(), k, hotbarPos.x + k * 18, hotbarPos.y));
        }
    }

    public PlayerInventory getPlayerInventory() {
        return this.inventory;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }
}

