/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosAPI;

public class SPacketBreakCurio {
    private int entityId;
    private int slotId;
    private String curioId;

    public SPacketBreakCurio(int entityId, String curioId, int slotId) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.curioId = curioId;
    }

    public static void encode(SPacketBreakCurio msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.slotId);
    }

    public static SPacketBreakCurio decode(PacketBuffer buf) {
        return new SPacketBreakCurio(buf.readInt(), buf.func_150789_c(25), buf.readInt());
    }

    public static void handle(SPacketBreakCurio msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CuriosAPI.getCuriosHandler(livingEntity).ifPresent(handler -> {
                    ItemStack stack = handler.getStackInSlot(msg.curioId, msg.slotId);
                    CuriosAPI.getCurio(stack).ifPresent(curio -> curio.onCurioBreak(stack, livingEntity));
                    if (!CuriosAPI.getCurio(stack).isPresent() && !stack.func_190926_b()) {
                        if (!livingEntity.func_174814_R()) {
                            livingEntity.field_70170_p.func_184134_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_187635_cQ, livingEntity.func_184176_by(), 0.8f, 0.8f + livingEntity.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
                        }
                        for (int i = 0; i < 5; ++i) {
                            Vec3d vec3d = new Vec3d(((double)livingEntity.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                            vec3d = vec3d.func_178789_a(-livingEntity.field_70125_A * ((float)Math.PI / 180));
                            vec3d = vec3d.func_178785_b(-livingEntity.field_70177_z * ((float)Math.PI / 180));
                            double d0 = (double)(-livingEntity.func_70681_au().nextFloat()) * 0.6 - 0.3;
                            Vec3d vec3d1 = new Vec3d(((double)livingEntity.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
                            vec3d1 = vec3d1.func_178789_a(-livingEntity.field_70125_A * ((float)Math.PI / 180));
                            vec3d1 = vec3d1.func_178785_b(-livingEntity.field_70177_z * ((float)Math.PI / 180));
                            vec3d1 = vec3d1.func_72441_c(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)livingEntity.func_70047_e(), livingEntity.func_226281_cx_());
                            livingEntity.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                        }
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

