/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.crafting.recipe;

import java.util.Collection;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.item.DrillHeadItem;
import net.silentchaos512.supermultidrills.item.DrillItem;

public class DrillHeadSwapRecipe
extends ExtendedShapelessRecipe {
    public static final ResourceLocation NAME = SuperMultiDrills.getId("drill_head_swap");
    public static final ExtendedShapelessRecipe.Serializer<DrillHeadSwapRecipe> SERIALIZER = ExtendedShapelessRecipe.Serializer.basic(DrillHeadSwapRecipe::new);

    private DrillHeadSwapRecipe(ShapelessRecipe recipe) {
        super(recipe);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        return this.getBaseRecipe().func_77569_a(inv, world);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack drill = list.uniqueOfType(DrillItem.class);
        ItemStack head = list.uniqueOfType(DrillHeadItem.class);
        if (drill.func_190926_b() || head.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        PartDataList drillParts = GearData.getConstructionParts((ItemStack)drill);
        PartDataList headParts = GearData.getConstructionParts((ItemStack)head);
        drillParts.removeIf(p -> p.getType() == PartType.MAIN);
        drillParts.addAll((Collection)headParts);
        ItemStack result = drill.func_77946_l();
        GearData.writeConstructionParts((ItemStack)result, (Collection)drillParts);
        GearData.recalculateStats((ItemStack)result, (PlayerEntity)ForgeHooks.getCraftingPlayer());
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            PartDataList parts = GearData.getConstructionParts((ItemStack)stack);
            if (DrillHeadSwapRecipe.isDrillHead(parts)) {
                list.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            ItemStack toolHead = StackList.from((IInventory)inv).uniqueMatch(s -> DrillHeadSwapRecipe.isDrillHead(GearData.getConstructionParts((ItemStack)s)));
            ItemStack copy = toolHead.func_77946_l();
            parts.removeIf(p -> p.getType() != PartType.MAIN);
            GearData.writeConstructionParts((ItemStack)copy, (Collection)parts);
            GearData.recalculateStats((ItemStack)copy, (PlayerEntity)ForgeHooks.getCraftingPlayer());
            list.set(i, (Object)copy);
        }
        return list;
    }

    private static boolean isDrillHead(PartDataList parts) {
        return parts.stream().allMatch(p -> {
            PartType type = p.getType();
            return type == PartType.MAIN || type == PartType.TIP || type == PartType.HIGHLIGHT;
        });
    }
}

