/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.caelus;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusAPI;
import top.theillusivec4.caelus.client.ClientEventHandler;
import top.theillusivec4.caelus.client.KeyRegistry;
import top.theillusivec4.caelus.client.renderer.CaelusElytraLayer;
import top.theillusivec4.caelus.common.CaelusConfig;
import top.theillusivec4.caelus.common.network.NetworkHandler;

@Mod(value="caelus")
public class Caelus {
    public static final String MODID = "caelus";
    public static final ResourceLocation DISABLED_ICON = new ResourceLocation("caelus", "textures/gui/flight_disabled.png");

    public Caelus() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::process);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CaelusConfig.clientSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent evt) {
        NetworkHandler.register();
    }

    private void process(InterModProcessEvent evt) {
        evt.getIMCStream("elytraRender"::equals).filter(msg -> msg.getMessageSupplier().get() instanceof Function).map(msg -> (Function)msg.getMessageSupplier().get()).forEach(func -> CaelusAPI.renderFunctions.add((Function<LivingEntity, CaelusAPI.ElytraRender>)func));
    }

    @SubscribeEvent
    public void attachAttribute(EntityEvent.EntityConstructing evt) {
        if (evt.getEntity() instanceof PlayerEntity) {
            ((PlayerEntity)evt.getEntity()).func_110140_aT().func_111150_b(CaelusAPI.ELYTRA_FLIGHT);
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent evt) {
        if (!(evt.getEntityLiving() instanceof PlayerEntity) || evt.getSlot() != EquipmentSlotType.CHEST) {
            return;
        }
        ItemStack from = evt.getFrom();
        ItemStack to = evt.getTo();
        IAttributeInstance attributeInstance = evt.getEntityLiving().func_110148_a(CaelusAPI.ELYTRA_FLIGHT);
        if (from.func_77973_b() instanceof ElytraItem) {
            attributeInstance.func_111124_b(CaelusAPI.ELYTRA_MODIFIER);
        }
        if (to.func_77973_b() instanceof ElytraItem && !attributeInstance.func_180374_a(CaelusAPI.ELYTRA_MODIFIER) && ElytraItem.func_185069_d((ItemStack)to)) {
            attributeInstance.func_111121_a(CaelusAPI.ELYTRA_MODIFIER);
        }
    }

    @Mod.EventBusSubscriber(modid="caelus", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientSetup {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent evt) {
            KeyRegistry.register();
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        }

        @SubscribeEvent
        public static void postSetup(FMLLoadCompleteEvent evt) {
            EntityRendererManager rendererManager = Minecraft.func_71410_x().func_175598_ae();
            rendererManager.getSkinMap().values().forEach(renderer -> renderer.func_177094_a(new CaelusElytraLayer(renderer)));
            rendererManager.field_78729_o.values().forEach(renderer -> {
                if (renderer instanceof LivingRenderer) {
                    LivingRenderer livingRenderer = (LivingRenderer)renderer;
                    livingRenderer.func_177094_a(new CaelusElytraLayer(livingRenderer));
                }
            });
        }
    }
}

