/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;

public class EdCraftingTable {
    public static boolean with_assist = true;
    public static boolean with_assist_direct_history_refab = false;
    public static boolean with_assist_quickmove_buttons = false;
    public static boolean with_crafting_slot_mouse_scrolling = true;
    public static boolean with_outslot_defined_refab = true;

    public static final void on_config(boolean without_crafting_assist, boolean with_assist_immediate_history_refab, boolean with_quickmove_buttons, boolean without_crafting_slot_mouse_scrolling) {
        with_assist = !without_crafting_assist;
        with_assist_direct_history_refab = with_assist_immediate_history_refab;
        with_assist_quickmove_buttons = with_quickmove_buttons;
        with_crafting_slot_mouse_scrolling = !without_crafting_slot_mouse_scrolling;
        with_outslot_defined_refab = with_assist;
        CraftingHistory.max_history_size(32);
    }

    public static class CraftingTableGrid
    extends CraftingInventory {
        protected final Container container;
        protected final IInventory inventory;

        public CraftingTableGrid(Container container_, IInventory block_inventory) {
            super(container_, 3, 3);
            this.container = container_;
            this.inventory = block_inventory;
        }

        public int func_70302_i_() {
            return 9;
        }

        public void func_174889_b(PlayerEntity player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(PlayerEntity player) {
            this.inventory.func_174886_c(player);
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(index, stack);
            this.container.func_75130_a((IInventory)this);
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = this.inventory.func_70298_a(index, count);
            if (!stack.func_190926_b()) {
                this.container.func_75130_a((IInventory)this);
            }
            return stack;
        }
    }

    public static class CraftingGridSlot
    extends Slot {
        public CraftingGridSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }
    }

    public static class CraftingOutputSlot
    extends CraftingResultSlot {
        private final CraftingTableContainer container;
        private final PlayerEntity player;

        public CraftingOutputSlot(CraftingTableContainer container, PlayerEntity player, CraftingInventory craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
            this.container = container;
            this.player = player;
        }

        protected void func_75208_c(ItemStack stack) {
            if (with_assist && this.player.field_70170_p != null && !this.player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
                IRecipe recipe = ((CraftResultInventory)this.field_75224_c).func_193055_i();
                ArrayList<ItemStack> grid = new ArrayList<ItemStack>();
                grid.add(stack);
                for (int i = 0; i < 9; ++i) {
                    grid.add(this.container.inventory_.func_70301_a(i));
                }
                if (recipe instanceof ICraftingRecipe) {
                    this.container.history().add(grid, (ICraftingRecipe)recipe);
                    this.container.history().reset_current();
                    this.container.syncHistory();
                }
            }
            super.func_75208_c(stack);
        }
    }

    private static class CraftingHistory {
        public static final int RESULT_STACK_INDEX = 0;
        public static final int INPUT_STACKS_BEGIN = 1;
        public static final List<ItemStack> NOTHING = new ArrayList<ItemStack>();
        private static int max_history_size_ = 5;
        private final World world;
        private List<String> history_ = new ArrayList<String>();
        private String stash_ = new String();
        private int current_ = -1;
        private List<ItemStack> current_stacks_ = new ArrayList<ItemStack>();
        private ICraftingRecipe current_recipe_ = null;

        public CraftingHistory(World world) {
            this.world = world;
        }

        public static int max_history_size() {
            return max_history_size_;
        }

        public static int max_history_size(int newsize) {
            max_history_size_ = MathHelper.func_76125_a((int)newsize, (int)0, (int)32);
            return max_history_size_;
        }

        public void read(CompoundNBT nbt) {
            try {
                this.clear();
                String s = nbt.func_74779_i("elements");
                if (s != null && s.length() > 0) {
                    String[] ls;
                    for (String e : ls = s.split("[|]")) {
                        this.history_.add(e.toLowerCase().trim());
                    }
                }
                this.current_ = !nbt.func_74764_b("current") ? -1 : MathHelper.func_76125_a((int)nbt.func_74762_e("current"), (int)-1, (int)(this.history_.size() - 1));
                this.stash_ = nbt.func_74779_i("stash");
                this.update_current();
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("Exception reading crafting table history NBT, resetting, exception is:" + ex.getMessage());
                this.clear();
            }
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("current", this.current_);
            nbt.func_74778_a("elements", String.join((CharSequence)"|", this.history_));
            if (!this.stash_.isEmpty()) {
                nbt.func_74778_a("stash", this.stash_);
            }
            return nbt;
        }

        public void clear() {
            this.reset_current();
            this.history_.clear();
        }

        public void reset_current() {
            this.current_ = -1;
            this.stash_ = "";
            this.current_stacks_ = NOTHING;
            this.current_recipe_ = null;
        }

        void update_current() {
            if (!this.stash_.isEmpty()) {
                Tuple<ICraftingRecipe, List<ItemStack>> data = this.str2stacks(this.stash_);
                if (data != null) {
                    this.current_recipe_ = (ICraftingRecipe)data.func_76341_a();
                    this.current_stacks_ = (List)data.func_76340_b();
                }
            } else if (this.current_ < 0 || this.current_ >= this.history_.size()) {
                this.reset_current();
            } else {
                Tuple<ICraftingRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(this.current_));
                if (data == null) {
                    this.reset_current();
                    return;
                }
                this.current_recipe_ = (ICraftingRecipe)data.func_76341_a();
                this.current_stacks_ = (List)data.func_76340_b();
            }
        }

        public void stash(List<ItemStack> grid_stacks, ICraftingRecipe recipe) {
            if (grid_stacks.size() == 9) {
                ArrayList<ItemStack> result_and_stacks = new ArrayList<ItemStack>();
                result_and_stacks.add(recipe.func_77571_b());
                result_and_stacks.addAll(grid_stacks);
                this.stash_ = this.stacks2str(result_and_stacks, recipe);
                this.current_stacks_ = result_and_stacks;
            } else {
                this.stash_ = this.stacks2str(grid_stacks, recipe);
                this.current_stacks_ = grid_stacks;
            }
            this.current_ = -1;
            this.current_recipe_ = recipe;
        }

        public int find(ItemStack result) {
            for (int i = 0; i < this.history_.size(); ++i) {
                Tuple<ICraftingRecipe, List<ItemStack>> data = this.str2stacks(this.history_.get(i));
                if (data == null || !((ICraftingRecipe)data.func_76341_a()).func_77571_b().func_77969_a(result)) continue;
                return i;
            }
            return -1;
        }

        public void add(List<ItemStack> grid_stacks, ICraftingRecipe recipe) {
            if (!with_assist) {
                this.clear();
                return;
            }
            this.stash_ = "";
            String s = this.stacks2str(grid_stacks, recipe);
            if (s.isEmpty()) {
                return;
            }
            String recipe_filter = recipe.func_199560_c().toString() + ";";
            this.history_.removeIf(e -> e.equals(s));
            this.history_.removeIf(e -> e.startsWith(recipe_filter));
            this.history_.add(s);
            while (this.history_.size() > CraftingHistory.max_history_size()) {
                this.history_.remove(0);
            }
            if (this.current_ >= this.history_.size()) {
                this.reset_current();
            }
        }

        public String stacks2str(List<ItemStack> grid_stacks, ICraftingRecipe recipe) {
            if (grid_stacks == null || recipe == null) {
                return "";
            }
            int num_stacks = grid_stacks.size();
            if (num_stacks < 9 || num_stacks > 10) {
                return "";
            }
            ArrayList<String> items = new ArrayList<String>();
            items.add(recipe.func_199560_c().toString());
            if (num_stacks < 10) {
                items.add(recipe.func_77571_b().func_77973_b().getRegistryName().toString());
            }
            for (ItemStack st : grid_stacks) {
                if (st.func_190926_b()) {
                    items.add("");
                    continue;
                }
                ResourceLocation rl = st.func_77973_b().getRegistryName();
                items.add(rl.func_110624_b().equals("minecraft") ? rl.func_110623_a() : rl.toString());
            }
            return String.join((CharSequence)";", items);
        }

        @Nullable
        public Tuple<ICraftingRecipe, List<ItemStack>> str2stacks(String entry) {
            if (this.world == null || entry == null || entry.isEmpty()) {
                return null;
            }
            try {
                ArrayList<String> item_regnames = new ArrayList<String>(Arrays.asList(entry.split("[;]")));
                if (item_regnames == null || item_regnames.size() < 2 || item_regnames.size() > 11) {
                    return null;
                }
                while (item_regnames.size() < 11) {
                    item_regnames.add("");
                }
                String recipe_name = item_regnames.remove(0);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (String regname : item_regnames) {
                    ItemStack stack = ItemStack.field_190927_a;
                    if (!regname.isEmpty()) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regname));
                        stack = item == null || item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item, 1);
                    }
                    stacks.add(stack);
                }
                if (stacks.size() != 10 || ((ItemStack)stacks.get(0)).func_190926_b()) {
                    return null;
                }
                IRecipe recipe = this.world.func_199532_z().func_215367_a(new ResourceLocation(recipe_name)).orElse(null);
                if (!(recipe instanceof ICraftingRecipe)) {
                    return null;
                }
                return new Tuple((Object)((ICraftingRecipe)recipe), stacks);
            }
            catch (Throwable ex) {
                ModEngineersDecor.logger().error("History stack building failed: " + ex.getMessage());
                return null;
            }
        }

        public List<ItemStack> current() {
            return this.current_stacks_;
        }

        public ICraftingRecipe current_recipe() {
            return this.current_recipe_;
        }

        public void next() {
            this.stash_ = "";
            this.current_ = this.history_.isEmpty() ? -1 : (++this.current_ >= this.history_.size() ? -1 : this.current_);
            this.update_current();
        }

        public void prev() {
            this.stash_ = "";
            this.current_ = this.history_.isEmpty() ? -1 : (--this.current_ < -1 ? this.history_.size() - 1 : this.current_);
            this.update_current();
        }

        public void reset_selection() {
            this.current_ = -1;
            this.stash_ = "";
            this.update_current();
        }

        public void selection(int index) {
            this.current_ = index < 0 || index >= this.history_.size() ? -1 : index;
            this.update_current();
        }

        public int selection() {
            return this.current_;
        }

        public int size() {
            return this.history_.size();
        }

        public String toString() {
            String rec = this.current_recipe_ == null ? "none" : this.current_recipe_.func_199560_c().toString();
            StringBuilder s = new StringBuilder("{ current:" + this.current_ + ", recipe:'" + rec + "', elements:[ ");
            for (int i = 0; i < this.history_.size(); ++i) {
                s.append("{i:").append(i).append(", e:[").append(this.history_.get(i)).append("], stash: '").append(this.stash_).append("'}");
            }
            return s.toString();
        }
    }

    public static enum PlacementResult {
        UNCHANGED,
        INCOMPLETE,
        PLACED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CraftingTableGui
    extends ContainerScreen<CraftingTableContainer> {
        protected static final ResourceLocation BACKGROUND = new ResourceLocation("engineersdecor", "textures/gui/treated_wood_crafting_table.png");
        protected final PlayerEntity player;
        protected final ArrayList<Button> buttons = new ArrayList();
        protected final boolean[] history_slot_tooltip = new boolean[]{false, false, false, false, false, false, false, false, false, false};

        public CraftingTableGui(CraftingTableContainer container, PlayerInventory playerInventory, ITextComponent title) {
            super((Container)container, playerInventory, title);
            this.player = playerInventory.field_70458_d;
        }

        public void init() {
            super.init();
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            this.buttons.clear();
            if (with_assist) {
                this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 158, y0 + 44, 12, 12, 194, 44, 12, BACKGROUND, bt -> this.action("next"))));
                this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 158, y0 + 30, 12, 12, 180, 30, 12, BACKGROUND, bt -> this.action("prev"))));
                this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 158, y0 + 58, 12, 12, 194, 8, 12, BACKGROUND, bt -> this.action("clear"))));
                this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 132, y0 + 18, 20, 10, 183, 95, 12, BACKGROUND, bt -> this.action("next-recipe"))));
                if (with_assist_quickmove_buttons) {
                    this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 49, y0 + 34, 9, 17, 219, 34, 17, BACKGROUND, bt -> this.action("from-storage"))));
                    this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 49, y0 + 52, 9, 17, 208, 16, 17, BACKGROUND, bt -> this.action("to-storage"))));
                    this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 77, y0 + 71, 17, 9, 198, 71, 9, BACKGROUND, bt -> this.action("from-player"))));
                    this.buttons.add((Button)this.addButton((Widget)new ImageButton(x0 + 59, y0 + 71, 17, 9, 180, 71, 9, BACKGROUND, bt -> this.action("to-player"))));
                }
            }
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (with_assist) {
                boolean is_collision;
                this.buttons.get((int)3).visible = is_collision = ((CraftingTableContainer)this.func_212873_a_()).has_recipe_collision();
                this.buttons.get((int)3).active = is_collision;
            }
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_191948_b(int mouseX, int mouseY) {
            if (!this.player.field_71071_by.func_70445_o().func_190926_b() || this.getSlotUnderMouse() == null) {
                return;
            }
            Slot slot = this.getSlotUnderMouse();
            if (!slot.func_75211_c().func_190926_b()) {
                this.renderTooltip(slot.func_75211_c(), mouseX, mouseY);
                return;
            }
            if (with_assist) {
                int hist_index = -1;
                if (slot instanceof CraftingResultSlot) {
                    hist_index = 0;
                } else if (slot.field_75224_c instanceof CraftingInventory) {
                    hist_index = slot.getSlotIndex() + 1;
                }
                if (hist_index < 0 || hist_index >= this.history_slot_tooltip.length) {
                    return;
                }
                if (!this.history_slot_tooltip[hist_index]) {
                    return;
                }
                ItemStack hist_stack = ((CraftingTableContainer)this.func_212873_a_()).history().current().get(hist_index);
                if (!hist_stack.func_190926_b()) {
                    this.renderTooltip(hist_stack, mouseX, mouseY);
                }
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            this.blit(x0, y0, 0, 0, this.field_146999_f, this.field_147000_g);
            if (with_assist) {
                for (int i = 0; i < this.history_slot_tooltip.length; ++i) {
                    this.history_slot_tooltip[i] = false;
                }
                List<ItemStack> crafting_template = ((CraftingTableContainer)this.func_212873_a_()).history().current();
                if (crafting_template == null || crafting_template.isEmpty()) {
                    return;
                }
                int i = 0;
                for (Tuple e : ((CraftingTableContainer)this.func_212873_a_()).CRAFTING_SLOT_COORDINATES) {
                    if (i == 0) continue;
                    if (((CraftingTableContainer)this.func_212873_a_()).func_75139_a(i).func_75216_d() && !((CraftingTableContainer)this.func_212873_a_()).func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                for (Tuple e : ((CraftingTableContainer)this.func_212873_a_()).CRAFTING_SLOT_COORDINATES) {
                    ItemStack stack = crafting_template.get(i);
                    if (!stack.func_190926_b()) {
                        if (!((CraftingTableContainer)this.func_212873_a_()).func_75139_a(i).func_75216_d()) {
                            this.history_slot_tooltip[i] = true;
                        }
                        if (i == 0 && ((CraftingTableContainer)this.func_212873_a_()).func_75139_a(i).func_75211_c().func_77969_a(crafting_template.get(i))) continue;
                        this.draw_template_item_at(stack, x0, y0, (Integer)e.func_76341_a(), (Integer)e.func_76340_b());
                    }
                    ++i;
                }
            }
        }

        protected void draw_template_item_at(ItemStack stack, int x0, int y0, int x, int y) {
            int main_zl = this.getBlitOffset();
            float zl = this.itemRenderer.field_77023_b;
            this.itemRenderer.field_77023_b = -80.0f;
            RenderSystem.enableRescaleNormal();
            this.itemRenderer.func_175042_a(stack, x0 + x, y0 + y);
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableLighting();
            RenderSystem.disableColorMaterial();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            this.itemRenderer.field_77023_b = zl;
            this.setBlitOffset(100);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.8f);
            this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
            this.blit(x0 + x, y0 + y, x, y, 16, 16);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.setBlitOffset(main_zl);
        }

        protected void action(String message) {
            this.action(message, new CompoundNBT());
        }

        protected void action(String message, CompoundNBT nbt) {
            ((CraftingTableContainer)this.func_212873_a_()).onGuiAction(message, nbt);
        }

        protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
            if (type == ClickType.PICKUP) {
                boolean place_refab;
                boolean bl = place_refab = slot instanceof CraftingResultSlot && !slot.func_75216_d();
                if (place_refab && with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                super.func_184098_a(slot, slotId, mouseButton, type);
                if (place_refab && !with_assist_direct_history_refab) {
                    this.on_history_item_placement();
                }
                return;
            }
            if (type == ClickType.QUICK_MOVE && slotId > 0 && slot.func_75216_d() && with_assist) {
                List<ItemStack> history = ((CraftingTableContainer)this.func_212873_a_()).history().current();
                boolean palce_in_crafting_grid = false;
                if (slotId > 9) {
                    boolean bl = palce_in_crafting_grid = !history.isEmpty();
                    if (!palce_in_crafting_grid) {
                        for (int i = 0; i < 9; ++i) {
                            if (((CraftingTableContainer)this.func_212873_a_()).func_75139_a(i).func_75211_c().func_190926_b()) continue;
                            palce_in_crafting_grid = true;
                            break;
                        }
                    }
                }
                if (palce_in_crafting_grid) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a("containerslot", slotId);
                    if (Auxiliaries.isCtrlDown()) {
                        nbt.func_74757_a("move-all", true);
                    }
                    this.action("place-stack", nbt);
                    return;
                }
                if (Auxiliaries.isCtrlDown()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a("containerslot", slotId);
                    this.action("move-stacks", nbt);
                    return;
                }
            }
            super.func_184098_a(slot, slotId, mouseButton, type);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double wheel_inc) {
            Slot resultSlot = this.getSlotUnderMouse();
            if (!with_crafting_slot_mouse_scrolling || !(resultSlot instanceof CraftingResultSlot)) {
                return this.func_212930_a(mouseX, mouseY).filter(evl -> evl.mouseScrolled(mouseX, mouseY, wheel_inc)).isPresent();
            }
            int count = resultSlot.func_75211_c().func_190916_E();
            int limit = (Auxiliaries.isShiftDown() ? 2 : 1) * (Auxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0.1) {
                if (count > 0) {
                    if (count < resultSlot.func_75211_c().func_77976_d() && count < resultSlot.func_75219_a()) {
                        CompoundNBT nbt = new CompoundNBT();
                        if (limit > 1) {
                            nbt.func_74768_a("limit", limit);
                        }
                        this.action("inc-crafting-stacks", nbt);
                    }
                } else if (!((CraftingTableContainer)this.func_212873_a_()).history().current().isEmpty()) {
                    this.action("place-refab");
                }
            } else if (wheel_inc < -0.1 && count > 0) {
                CompoundNBT nbt = new CompoundNBT();
                if (limit > 1) {
                    nbt.func_74768_a("limit", limit);
                }
                this.action("dec-crafting-stacks", nbt);
            }
            return true;
        }

        private void on_history_item_placement() {
            if (((CraftingTableContainer)this.func_212873_a_()).history().current().isEmpty()) {
                return;
            }
            Slot resultSlot = this.getSlotUnderMouse();
            if (!(resultSlot instanceof CraftingResultSlot)) {
                return;
            }
            this.action("place-refab");
        }
    }

    public static class CraftingTableContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        protected static final String BUTTON_NEXT = "next";
        protected static final String BUTTON_PREV = "prev";
        protected static final String BUTTON_CLEAR_GRID = "clear";
        protected static final String BUTTON_FROM_STORAGE = "from-storage";
        protected static final String BUTTON_TO_STORAGE = "to-storage";
        protected static final String BUTTON_FROM_PLAYER = "from-player";
        protected static final String BUTTON_TO_PLAYER = "to-player";
        protected static final String BUTTON_NEXT_COLLISION_RECIPE = "next-recipe";
        protected static final String ACTION_PLACE_CURRENT_HISTORY_SEL = "place-refab";
        protected static final String ACTION_PLACE_SHIFTCLICKED_STACK = "place-stack";
        protected static final String ACTION_MOVE_ALL_STACKS = "move-stacks";
        protected static final String ACTION_INCREASE_CRAFTING_STACKS = "inc-crafting-stacks";
        protected static final String ACTION_DECREASE_CRAFTING_STACKS = "dec-crafting-stacks";
        public static final int CRAFTING_SLOTS_BEGIN = 0;
        public static final int NUM_OF_CRAFTING_SLOTS = 9;
        public static final int STORAGE_SLOTS_BEGIN = 9;
        public static final int NUM_OF_STORAGE_SLOTS = 8;
        public final ImmutableList<Tuple<Integer, Integer>> CRAFTING_SLOT_COORDINATES;
        private final PlayerEntity player_;
        private final IInventory inventory_;
        private final IWorldPosCallable wpc_;
        private final CraftingHistory history_;
        private final CraftingTableGrid matrix_;
        private final CraftResultInventory result_;
        private boolean has_recipe_collision_;
        private boolean crafting_matrix_changed_now_;

        public CraftingTableContainer(int cid, PlayerInventory pinv) {
            this(cid, pinv, (IInventory)new Inventory(17), IWorldPosCallable.field_221489_a);
        }

        private CraftingTableContainer(int cid, PlayerInventory pinv, IInventory block_inventory, IWorldPosCallable wpc) {
            super(ModContent.CT_TREATED_WOOD_CRAFTING_TABLE, cid);
            int x;
            int y;
            this.wpc_ = wpc;
            this.player_ = pinv.field_70458_d;
            this.inventory_ = block_inventory;
            World world = this.player_.field_70170_p;
            if (world.field_72995_K && this.inventory_ instanceof CraftingTableTileEntity) {
                world = ((CraftingTableTileEntity)this.inventory_).func_145831_w();
            }
            this.history_ = new CraftingHistory(world);
            this.result_ = new CraftResultInventory();
            this.matrix_ = new CraftingTableGrid(this, block_inventory);
            this.matrix_.func_174889_b(this.player_);
            this.func_75146_a((Slot)new CraftingOutputSlot(this, pinv.field_70458_d, this.matrix_, (IInventory)this.result_, 0, 134, 35));
            ArrayList<Tuple> slotpositions = new ArrayList<Tuple>();
            slotpositions.add(new Tuple((Object)134, (Object)35));
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 3; ++x) {
                    int xpos = 60 + x * 18;
                    int ypos = 17 + y * 18;
                    this.func_75146_a(new CraftingGridSlot((IInventory)this.matrix_, x + y * 3, xpos, ypos));
                    slotpositions.add(new Tuple((Object)xpos, (Object)ypos));
                }
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)pinv, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)pinv, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 4; ++y) {
                for (x = 0; x < 2; ++x) {
                    this.func_75146_a(new Slot((IInventory)this.matrix_, x + y * 2 + 9, 8 + x * 18, 9 + y * 18));
                }
            }
            if (!this.player_.field_70170_p.field_72995_K && this.inventory_ instanceof CraftingTableTileEntity) {
                this.history_.read(((CraftingTableTileEntity)this.inventory_).history.func_74737_b());
                this.syncHistory();
            }
            this.CRAFTING_SLOT_COORDINATES = ImmutableList.copyOf(slotpositions);
            this.func_75130_a((IInventory)this.matrix_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public void func_75130_a(IInventory inv) {
            this.func_75142_b();
            this.wpc_.func_221486_a((world, pos) -> {
                if (world.field_72995_K) {
                    return;
                }
                try {
                    this.crafting_matrix_changed_now_ = true;
                    ServerPlayerEntity player = (ServerPlayerEntity)this.player_;
                    ItemStack stack = ItemStack.field_190927_a;
                    List recipes = world.func_73046_m().func_199529_aN().func_215370_b(IRecipeType.field_222149_a, (IInventory)this.matrix_, world);
                    this.has_recipe_collision_ = false;
                    if (recipes.size() > 0) {
                        ICraftingRecipe recipe = (ICraftingRecipe)recipes.get(0);
                        IRecipe currently_used = this.result_.func_193055_i();
                        boolean bl = this.has_recipe_collision_ = recipes.size() > 1;
                        if (recipes.size() > 1 && currently_used instanceof ICraftingRecipe && recipes.contains(currently_used)) {
                            recipe = (ICraftingRecipe)currently_used;
                        }
                        if (this.result_.func_201561_a(world, player, (IRecipe)recipe)) {
                            stack = recipe.func_77572_b((IInventory)this.matrix_);
                        }
                    }
                    this.result_.func_70299_a(0, stack);
                    player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, stack));
                    this.syncProperties();
                }
                catch (Throwable exc) {
                    ModEngineersDecor.logger().error("Recipe failed:", exc);
                }
            });
        }

        public void func_75134_a(PlayerEntity player) {
            this.matrix_.func_174886_c(player);
            this.result_.func_174888_l();
            this.result_.func_174886_c(player);
            if (player != null) {
                for (Slot e : player.field_71069_bz.field_75151_b) {
                    if (!(e instanceof CraftingResultSlot)) continue;
                    ((CraftingResultSlot)e).func_75215_d(ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return slot.field_75224_c != this.result_ && super.func_94530_a(stack, slot);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slotstack = slot.func_75211_c();
            ItemStack stack = slotstack.func_77946_l();
            if (index == 0) {
                this.wpc_.func_221486_a((world, pos) -> slotstack.func_77973_b().func_77622_d(slotstack, world, player));
                if (!this.func_75135_a(slotstack, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotstack, stack);
            } else if (index >= 10 && index < 46 ? !this.func_75135_a(slotstack, 46, 54, false) : (index >= 46 && index < 54 ? !this.func_75135_a(slotstack, 10, 46, false) : !this.func_75135_a(slotstack, 10, 46, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotstack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotstack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(player, slotstack);
            if (index == 0) {
                player.func_71019_a(itemstack2, false);
            }
            return stack;
        }

        public ItemStack func_184996_a(int slotId, int button, ClickType clickType, PlayerEntity player) {
            this.crafting_matrix_changed_now_ = false;
            ItemStack stack = super.func_184996_a(slotId, button, clickType, player);
            if (with_outslot_defined_refab && slotId == 0 && clickType == ClickType.PICKUP && !this.crafting_matrix_changed_now_ && !player.field_70170_p.func_201670_d() && this.crafting_grid_empty()) {
                ItemStack dragged = player.field_71071_by.func_70445_o();
                if (dragged != null && !dragged.func_190926_b()) {
                    this.try_result_stack_refab(dragged, player.field_70170_p);
                } else if (!this.history().current().isEmpty()) {
                    this.try_result_stack_refab(this.history().current_recipe().func_77571_b(), player.field_70170_p);
                }
            }
            return stack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundNBT nbt) {
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
            if (nbt.func_74764_b("history")) {
                this.history_.read(nbt.func_74775_l("history"));
            }
            if (nbt.func_74764_b("hascollision")) {
                this.has_recipe_collision_ = nbt.func_74767_n("hascollision");
            }
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            boolean changed = false;
            boolean player_inventory_changed = false;
            if (with_assist && nbt.func_74764_b("action")) {
                switch (nbt.func_74779_i("action")) {
                    case "next": {
                        this.history_.next();
                        this.syncHistory();
                        if (this.clear_grid_to_player(player)) {
                            changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        changed = true;
                        break;
                    }
                    case "prev": {
                        this.history_.prev();
                        this.syncHistory();
                        if (this.clear_grid_to_player(player)) {
                            changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        changed = true;
                        break;
                    }
                    case "clear": {
                        this.history_.reset_selection();
                        this.syncHistory();
                        if (this.clear_grid_to_player(player)) {
                            changed = true;
                            player_inventory_changed = true;
                        }
                        if (!this.clear_grid_to_storage(player)) break;
                        changed = true;
                        break;
                    }
                    case "to-storage": {
                        if (!this.clear_grid_to_storage(player)) break;
                        changed = true;
                        break;
                    }
                    case "to-player": {
                        if (!this.clear_grid_to_player(player)) break;
                        changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case "from-storage": {
                        if (this.place_stacks(new Inventories.SlotRange[]{new Inventories.SlotRange(this.inventory_, 9, 17)}, this.refab_crafting_stacks()) == PlacementResult.UNCHANGED) break;
                        changed = true;
                        break;
                    }
                    case "from-player": {
                        if (this.place_stacks(new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36), new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9)}, this.refab_crafting_stacks()) == PlacementResult.UNCHANGED) break;
                        changed = true;
                        player_inventory_changed = true;
                        break;
                    }
                    case "place-refab": {
                        if (this.place_stacks(new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9), new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36), new Inventories.SlotRange(this.inventory_, 9, 17)}, this.refab_crafting_stacks()) == PlacementResult.UNCHANGED) break;
                        changed = true;
                        break;
                    }
                    case "place-stack": {
                        ItemStack stack;
                        int container_slot_id = nbt.func_74762_e("containerslot");
                        if (container_slot_id < 10 || container_slot_id > 53) break;
                        if (container_slot_id >= 46) {
                            int storage_slot = container_slot_id - 46 + 9;
                            PlacementResult stat = this.distribute_stack(this.inventory_, storage_slot);
                            if (stat == PlacementResult.UNCHANGED) break;
                            changed = true;
                            break;
                        }
                        int player_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                        ItemStack reference_stack = player.field_71071_by.func_70301_a(player_slot).func_77946_l();
                        if (reference_stack.func_190926_b() || this.distribute_stack((IInventory)player.field_71071_by, player_slot) == PlacementResult.UNCHANGED) break;
                        player_inventory_changed = true;
                        changed = true;
                        if (!nbt.func_74764_b("move-all")) break;
                        for (int i = 0; !(i >= player.field_71071_by.func_70302_i_() || Inventories.areItemStacksIdentical(reference_stack, stack = player.field_71071_by.func_70301_a(i)) && this.distribute_stack((IInventory)player.field_71071_by, i) == PlacementResult.UNCHANGED); ++i) {
                        }
                        break;
                    }
                    case "move-stacks": {
                        Inventories.SlotRange[] to_ranges;
                        int from_slot;
                        IInventory from_inventory;
                        int container_slot_id = nbt.func_74762_e("containerslot");
                        if (container_slot_id < 1 || container_slot_id > 53) break;
                        if (container_slot_id < 10) {
                            if (this.clear_grid_to_player(player)) {
                                changed = true;
                                player_inventory_changed = true;
                            }
                            if (!this.clear_grid_to_storage(player)) break;
                            changed = true;
                            break;
                        }
                        if (container_slot_id >= 46) {
                            from_inventory = this.inventory_;
                            from_slot = container_slot_id - 46 + 9;
                            to_ranges = new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36), new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9)};
                        } else {
                            from_inventory = player.field_71071_by;
                            from_slot = container_slot_id >= 37 ? container_slot_id - 37 : container_slot_id - 10 + 9;
                            to_ranges = new Inventories.SlotRange[]{new Inventories.SlotRange(this.inventory_, 9, 17)};
                        }
                        ItemStack reference_stack = from_inventory.func_70301_a(from_slot).func_77946_l();
                        if (reference_stack.func_190926_b()) break;
                        boolean abort = false;
                        for (int i = 0; i < from_inventory.func_70302_i_() && !abort; ++i) {
                            ItemStack stack = from_inventory.func_70301_a(i);
                            if (Inventories.areItemStacksDifferent(reference_stack, stack)) continue;
                            ItemStack remaining = from_inventory.func_70301_a(i);
                            for (Inventories.SlotRange range : to_ranges) {
                                if (!(remaining = range.insert(remaining, false, 0)).func_190926_b()) {
                                    abort = true;
                                    break;
                                }
                                player_inventory_changed = true;
                                changed = true;
                            }
                            from_inventory.func_70299_a(i, remaining);
                        }
                        break;
                    }
                    case "next-recipe": {
                        this.select_next_collision_recipe(this.inventory_);
                        break;
                    }
                    case "dec-crafting-stacks": {
                        changed = player_inventory_changed = this.decrease_grid_stacks(new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36), new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9), new Inventories.SlotRange(this.inventory_, 9, 17)}, MathHelper.func_76125_a((int)nbt.func_74762_e("limit"), (int)1, (int)8));
                        break;
                    }
                    case "inc-crafting-stacks": {
                        changed = player_inventory_changed = this.increase_grid_stacks(new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36), new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9), new Inventories.SlotRange(this.inventory_, 9, 17)}, MathHelper.func_76125_a((int)nbt.func_74762_e("limit"), (int)1, (int)8));
                    }
                }
            }
            if (changed) {
                this.inventory_.func_70296_d();
            }
            if (player_inventory_changed) {
                player.field_71071_by.func_70296_d();
            }
            if (changed || player_inventory_changed) {
                this.func_75130_a(this.inventory_);
                this.func_75142_b();
            }
        }

        public CraftingHistory history() {
            return this.history_;
        }

        private void syncHistory() {
            if (!with_assist) {
                return;
            }
            this.wpc_.func_221486_a((world, pos) -> {
                if (world.func_201670_d()) {
                    return;
                }
                CompoundNBT hist_nbt = this.history_.write();
                if (this.inventory_ instanceof CraftingTableTileEntity) {
                    ((CraftingTableTileEntity)this.inventory_).history = hist_nbt.func_74737_b();
                    this.inventory_.func_70296_d();
                }
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("history", (INBT)hist_nbt);
                nbt.func_74757_a("hascollision", this.has_recipe_collision_);
                Networking.PacketContainerSyncServerToClient.sendToListeners(world, this, nbt);
            });
        }

        private void syncProperties() {
            this.wpc_.func_221486_a((world, pos) -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74757_a("hascollision", this.has_recipe_collision_);
                Networking.PacketContainerSyncServerToClient.sendToListeners(world, this, nbt);
            });
        }

        public boolean has_recipe_collision() {
            return this.has_recipe_collision_;
        }

        public void select_next_collision_recipe(IInventory inv) {
            this.wpc_.func_221486_a((world, pos) -> {
                if (world.field_72995_K) {
                    return;
                }
                try {
                    ServerPlayerEntity player = (ServerPlayerEntity)this.player_;
                    List matching_recipes = world.func_73046_m().func_199529_aN().func_215370_b(IRecipeType.field_222149_a, (IInventory)this.matrix_, world);
                    if (matching_recipes.size() < 2) {
                        return;
                    }
                    IRecipe currently_used = this.result_.func_193055_i();
                    List usable_recipes = matching_recipes.stream().filter(r -> this.result_.func_201561_a(world, player, (IRecipe)r)).sorted((a, b) -> Integer.compare(a.func_199560_c().hashCode(), b.func_199560_c().hashCode())).collect(Collectors.toList());
                    for (int i = 0; i < usable_recipes.size(); ++i) {
                        if (usable_recipes.get(i) != currently_used) continue;
                        if (++i >= usable_recipes.size()) {
                            i = 0;
                        }
                        currently_used = (IRecipe)usable_recipes.get(i);
                        ItemStack stack = ((ICraftingRecipe)currently_used).func_77572_b((IInventory)this.matrix_);
                        this.result_.func_70299_a(0, stack);
                        this.result_.func_193056_a(currently_used);
                        break;
                    }
                    this.func_75130_a(inv);
                }
                catch (Throwable exc) {
                    ModEngineersDecor.logger().error("Recipe failed:", exc);
                }
            });
        }

        @Nullable
        private ICraftingRecipe find_first_recipe_for(World world, ItemStack stack) {
            return world.func_73046_m().func_199529_aN().func_199510_b().stream().filter(r -> r.func_222127_g() == IRecipeType.field_222149_a && r.func_77571_b().func_77969_a(stack)).findFirst().orElse(null);
        }

        private ItemStack search_inventory(ItemStack match_stack, ItemStack not_found_value) {
            Inventories.SlotRange[] search_ranges;
            for (Inventories.SlotRange range : search_ranges = new Inventories.SlotRange[]{new Inventories.SlotRange((IInventory)this.player_.field_71071_by, 0, 36), new Inventories.SlotRange(this.inventory_, 9, 17)}) {
                for (int i = 0; i < range.inventory.func_70302_i_(); ++i) {
                    ItemStack stack = range.inventory.func_70301_a(i);
                    if (!Inventories.areItemStacksIdentical(stack, match_stack)) continue;
                    return match_stack;
                }
            }
            return not_found_value;
        }

        private ItemStack search_inventory(ItemStack[] match_stacks, ItemStack not_found_value) {
            for (ItemStack match_stack : match_stacks) {
                ItemStack stack = this.search_inventory(match_stack, ItemStack.field_190927_a);
                if (stack.func_190926_b()) continue;
                return stack;
            }
            return not_found_value;
        }

        private ArrayList<ItemStack> placement_stacks(ICraftingRecipe recipe) {
            ArrayList<ItemStack> grid;
            block13: {
                block12: {
                    int w;
                    World world = this.player_.field_70170_p;
                    grid = new ArrayList<ItemStack>();
                    if (recipe.func_192400_c().size() > 9) {
                        return grid;
                    }
                    if (!(recipe instanceof ShapedRecipe)) break block12;
                    int endw = ((ShapedRecipe)recipe).func_192403_f();
                    int endh = ((ShapedRecipe)recipe).func_192404_g();
                    int ingredient_index = 0;
                    for (int i = 3 - endh; i > 0; --i) {
                        for (w = 0; w < 3; ++w) {
                            grid.add(ItemStack.field_190927_a);
                        }
                    }
                    for (int h = 3 - endh; h < 3; ++h) {
                        for (w = 0; w < 3; ++w) {
                            if (w >= endw || ingredient_index >= recipe.func_192400_c().size()) {
                                grid.add(ItemStack.field_190927_a);
                                continue;
                            }
                            ItemStack[] match_stacks = ((Ingredient)recipe.func_192400_c().get(ingredient_index++)).func_193365_a();
                            if (match_stacks.length == 0) {
                                grid.add(ItemStack.field_190927_a);
                                continue;
                            }
                            ItemStack preferred = this.search_inventory(match_stacks, match_stacks[0]);
                            if (preferred.func_190926_b()) {
                                grid.add(ItemStack.field_190927_a);
                                continue;
                            }
                            grid.add(preferred);
                        }
                    }
                    break block13;
                }
                if (!(recipe instanceof ShapelessRecipe)) break block13;
                for (int ingredient_index = 0; ingredient_index < recipe.func_192400_c().size(); ++ingredient_index) {
                    ItemStack[] match_stacks = ((Ingredient)recipe.func_192400_c().get(ingredient_index)).func_193365_a();
                    if (match_stacks.length == 0) {
                        grid.add(ItemStack.field_190927_a);
                        continue;
                    }
                    ItemStack preferred = this.search_inventory(match_stacks, match_stacks[0]);
                    if (preferred.func_190926_b()) {
                        grid.add(ItemStack.field_190927_a);
                        continue;
                    }
                    grid.add(preferred);
                }
                while (grid.size() < 9) {
                    grid.add(ItemStack.field_190927_a);
                }
            }
            return grid;
        }

        private boolean adapt_recipe_placement(ICraftingRecipe recipe, List<ItemStack> grid_stacks) {
            boolean changed = false;
            NonNullList ingredients = recipe.func_192400_c();
            for (int stack_index = 0; stack_index < grid_stacks.size(); ++stack_index) {
                ItemStack to_replace;
                ItemStack replacement = to_replace = grid_stacks.get(stack_index);
                if (to_replace.func_190926_b() || !this.search_inventory(to_replace, ItemStack.field_190927_a).func_190926_b()) continue;
                for (int ingredient_index = 0; ingredient_index < recipe.func_192400_c().size(); ++ingredient_index) {
                    ItemStack[] match_stacks = ((Ingredient)recipe.func_192400_c().get(ingredient_index)).func_193365_a();
                    if (!Arrays.stream(match_stacks).anyMatch(s -> Inventories.areItemStacksIdentical(s, to_replace))) continue;
                    replacement = this.search_inventory(match_stacks, to_replace);
                    changed = true;
                    break;
                }
                grid_stacks.set(stack_index, replacement);
            }
            return changed;
        }

        private void try_result_stack_refab(ItemStack output_stack, World world) {
            ICraftingRecipe recipe;
            int history_index = this.history().find(output_stack);
            if (history_index >= 0) {
                this.history().selection(history_index);
                recipe = this.history().current_recipe();
                List<ItemStack> grid_stacks = this.history().current().subList(1, this.history().current().size());
                if (this.adapt_recipe_placement(recipe, grid_stacks)) {
                    this.history().stash(grid_stacks, recipe);
                    recipe = this.history().current_recipe();
                }
            } else {
                recipe = this.find_first_recipe_for(world, output_stack);
                if (recipe != null) {
                    ArrayList<ItemStack> stacks = this.placement_stacks(recipe);
                    if (stacks.isEmpty()) {
                        recipe = null;
                    } else {
                        this.history().stash(stacks, recipe);
                        recipe = this.history().current_recipe();
                    }
                }
            }
            if (recipe != null) {
                this.func_75130_a(this.inventory_);
                this.syncHistory();
            }
        }

        private boolean crafting_grid_empty() {
            for (int i = 0; i < 10; ++i) {
                if (!this.func_75139_a(i).func_75216_d()) continue;
                return false;
            }
            return true;
        }

        private boolean itemstack_recipe_match(ItemStack grid_stack, ItemStack history_stack) {
            if (this.history_.current_recipe() != null) {
                NonNullList ingredients = this.history_.current_recipe().func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    boolean grid_match = false;
                    boolean dist_match = false;
                    for (ItemStack match : ingredient.func_193365_a()) {
                        if (match.func_185136_b(grid_stack)) {
                            dist_match = true;
                        }
                        if (match.func_185136_b(history_stack)) {
                            grid_match = true;
                        }
                        if (!dist_match || !grid_match) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private List<ItemStack> refab_crafting_stacks() {
            int i;
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
            List<ItemStack> tocraft = this.history_.current();
            int[] stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            if (tocraft.isEmpty()) {
                return slots;
            }
            for (int i2 = 0; i2 < 9 && i2 + 1 < tocraft.size(); ++i2) {
                ItemStack needed = tocraft.get(i2 + 1);
                ItemStack palced = this.inventory_.func_70301_a(i2 + 0);
                if (needed.func_190926_b() && !palced.func_190926_b()) {
                    return slots;
                }
                if (!palced.func_190926_b() && !this.itemstack_recipe_match(needed, palced)) {
                    return slots;
                }
                if (needed.func_190926_b()) continue;
                stack_sizes[i2] = palced.func_190916_E();
            }
            int min_placed = 64;
            int max_placed = 0;
            for (int i3 = 0; i3 < 9; ++i3) {
                if (stack_sizes[i3] < 0) continue;
                min_placed = Math.min(min_placed, stack_sizes[i3]);
                max_placed = Math.max(max_placed, stack_sizes[i3]);
            }
            int fillup_size = max_placed <= min_placed ? min_placed + 1 : max_placed;
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0 || fillup_size <= this.inventory_.func_70301_a(i + 0).func_77976_d()) continue;
                return slots;
            }
            for (i = 0; i < 9; ++i) {
                if (stack_sizes[i] < 0) {
                    slots.add(ItemStack.field_190927_a);
                    continue;
                }
                ItemStack st = this.inventory_.func_70301_a(i + 0).func_77946_l();
                if (st.func_190926_b()) {
                    st = tocraft.get(i + 1).func_77946_l();
                    st.func_190920_e(Math.min(st.func_77976_d(), fillup_size));
                } else {
                    st.func_190920_e(MathHelper.func_76125_a((int)(fillup_size - st.func_190916_E()), (int)0, (int)st.func_77976_d()));
                }
                slots.add(st);
            }
            return slots;
        }

        private List<ItemStack> incr_crafting_grid_stacks(int count) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ItemStack palced = this.inventory_.func_70301_a(i + 0).func_77946_l();
                if (!palced.func_190926_b()) {
                    palced.func_190920_e(count);
                }
                stacks.add(palced);
            }
            return stacks;
        }

        private boolean clear_grid_to_storage(PlayerEntity player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack stack = this.inventory_.func_70301_a(grid_i);
                if (stack.func_190926_b()) continue;
                ItemStack remaining = new Inventories.SlotRange(this.inventory_, 9, 17).insert(stack, false, 0);
                this.inventory_.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private boolean clear_grid_to_player(PlayerEntity player) {
            boolean changed = false;
            for (int grid_i = 0; grid_i < 9; ++grid_i) {
                ItemStack remaining = this.inventory_.func_70301_a(grid_i);
                if (remaining.func_190926_b()) continue;
                remaining = new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36).insert(remaining, true, 0);
                remaining = new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9).insert(remaining, true, 0);
                remaining = new Inventories.SlotRange((IInventory)player.field_71071_by, 9, 36).insert(remaining, false, 0);
                remaining = new Inventories.SlotRange((IInventory)player.field_71071_by, 0, 9).insert(remaining, false, 0);
                this.inventory_.func_70299_a(grid_i, remaining);
                changed = true;
            }
            return changed;
        }

        private PlacementResult place_stacks(Inventories.SlotRange[] ranges, List<ItemStack> to_fill) {
            if (this.history_.current_recipe() != null) {
                this.result_.func_193056_a((IRecipe)this.history_.current_recipe());
            }
            boolean slots_changed = false;
            if (!to_fill.isEmpty()) {
                block0: for (Inventories.SlotRange slot_range : ranges) {
                    for (int it_guard = 63; it_guard >= 0; --it_guard) {
                        boolean slots_updated = false;
                        for (int i = 0; i < 9; ++i) {
                            ItemStack grid_stack;
                            if (to_fill.get(i).func_190926_b() || (grid_stack = this.inventory_.func_70301_a(i + 0).func_77946_l()).func_190916_E() >= grid_stack.func_77976_d()) continue;
                            ItemStack req_stack = to_fill.get(i).func_77946_l();
                            req_stack.func_190920_e(1);
                            ItemStack mv_stack = slot_range.extract(req_stack);
                            if (mv_stack.func_190926_b()) continue;
                            to_fill.get(i).func_190918_g(1);
                            if (grid_stack.func_190926_b()) {
                                grid_stack = mv_stack.func_77946_l();
                            } else {
                                grid_stack.func_190917_f(mv_stack.func_190916_E());
                            }
                            this.inventory_.func_70299_a(i + 0, grid_stack);
                            slots_changed = true;
                            slots_updated = true;
                        }
                        if (!slots_updated) continue block0;
                    }
                }
            }
            boolean missing_item = false;
            for (ItemStack st : to_fill) {
                if (st.func_190926_b()) continue;
                missing_item = true;
                break;
            }
            if (!slots_changed) {
                return PlacementResult.UNCHANGED;
            }
            if (missing_item) {
                return PlacementResult.INCOMPLETE;
            }
            return PlacementResult.PLACED;
        }

        private PlacementResult distribute_stack(IInventory inventory, int slotno) {
            ItemStack to_distribute;
            List<ItemStack> to_refab = this.refab_crafting_stacks();
            if (this.history_.current_recipe() != null) {
                this.result_.func_193056_a((IRecipe)this.history_.current_recipe());
            }
            if ((to_distribute = inventory.func_70301_a(slotno).func_77946_l()).func_190926_b()) {
                return PlacementResult.UNCHANGED;
            }
            int[] matching_grid_stack_sizes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
            int max_matching_stack_size = -1;
            int min_matching_stack_size = 65;
            int total_num_missing_stacks = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack refab_stack;
                ItemStack grid_stack = this.inventory_.func_70301_a(i + 0);
                ItemStack itemStack = refab_stack = to_refab.isEmpty() ? ItemStack.field_190927_a : to_refab.get(i).func_77946_l();
                if (!grid_stack.func_190926_b() && Inventories.areItemStacksIdentical(grid_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = grid_stack.func_190916_E();
                    total_num_missing_stacks += grid_stack.func_77976_d() - grid_stack.func_190916_E();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!refab_stack.func_190926_b() && Inventories.areItemStacksIdentical(refab_stack, to_distribute)) {
                    matching_grid_stack_sizes[i] = 0;
                    total_num_missing_stacks += grid_stack.func_77976_d();
                    if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                        max_matching_stack_size = matching_grid_stack_sizes[i];
                    }
                    if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                    min_matching_stack_size = matching_grid_stack_sizes[i];
                    continue;
                }
                if (!grid_stack.func_190926_b() || refab_stack.func_190926_b() || !this.itemstack_recipe_match(to_distribute, refab_stack)) continue;
                matching_grid_stack_sizes[i] = 0;
                total_num_missing_stacks += grid_stack.func_77976_d();
                if (max_matching_stack_size < matching_grid_stack_sizes[i]) {
                    max_matching_stack_size = matching_grid_stack_sizes[i];
                }
                if (min_matching_stack_size <= matching_grid_stack_sizes[i]) continue;
                min_matching_stack_size = matching_grid_stack_sizes[i];
            }
            if (min_matching_stack_size < 0) {
                return PlacementResult.UNCHANGED;
            }
            int stack_limit_size = Math.min(to_distribute.func_77976_d(), this.inventory_.func_70297_j_());
            if (min_matching_stack_size >= stack_limit_size) {
                return PlacementResult.UNCHANGED;
            }
            int n_to_distribute = to_distribute.func_190916_E();
            for (int it_guard = 63; it_guard >= 0 && n_to_distribute > 0; --it_guard) {
                for (int i = 0; i < 9 && n_to_distribute > 0; ++i) {
                    if (matching_grid_stack_sizes[i] != min_matching_stack_size) continue;
                    int n = i;
                    matching_grid_stack_sizes[n] = matching_grid_stack_sizes[n] + 1;
                    --n_to_distribute;
                }
                if (min_matching_stack_size < max_matching_stack_size) {
                    ++min_matching_stack_size;
                } else {
                    max_matching_stack_size = ++min_matching_stack_size;
                }
                if (min_matching_stack_size >= stack_limit_size) break;
            }
            if (n_to_distribute == to_distribute.func_190916_E()) {
                return PlacementResult.UNCHANGED;
            }
            if (n_to_distribute <= 0) {
                inventory.func_70299_a(slotno, ItemStack.field_190927_a);
            } else {
                to_distribute.func_190920_e(n_to_distribute);
                inventory.func_70299_a(slotno, to_distribute);
            }
            for (int i = 0; i < 9; ++i) {
                if (matching_grid_stack_sizes[i] < 0) continue;
                ItemStack grid_stack = this.inventory_.func_70301_a(i + 0).func_77946_l();
                if (grid_stack.func_190926_b()) {
                    grid_stack = to_distribute.func_77946_l();
                }
                grid_stack.func_190920_e(matching_grid_stack_sizes[i]);
                this.inventory_.func_70299_a(i + 0, grid_stack);
            }
            return PlacementResult.PLACED;
        }

        private boolean decrease_grid_stacks(Inventories.SlotRange[] ranges, int limit) {
            boolean changed = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.inventory_.func_70301_a(i + 0).func_77946_l();
                if (stack.func_190926_b()) continue;
                for (Inventories.SlotRange range : ranges) {
                    ItemStack remaining = range.insert(stack, false, limit);
                    if (remaining.func_190916_E() < stack.func_190916_E()) {
                        changed = true;
                    }
                    boolean stop = remaining.func_190916_E() <= Math.max(0, stack.func_190916_E() - limit);
                    stack = remaining;
                    if (stop) break;
                }
                this.inventory_.func_70299_a(i + 0, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
            }
            return changed;
        }

        private boolean increase_grid_stacks(Inventories.SlotRange[] ranges, int limit) {
            return this.place_stacks(ranges, this.incr_crafting_grid_stacks(limit)) != PlacementResult.UNCHANGED;
        }
    }

    public static class CraftingTableTileEntity
    extends TileEntity
    implements IInventory,
    INameable,
    INamedContainerProvider {
        public static final int NUM_OF_SLOTS = 17;
        protected NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        protected CompoundNBT history = new CompoundNBT();

        public CraftingTableTileEntity() {
            this(ModContent.TET_TREATED_WOOD_CRAFTING_TABLE);
        }

        public CraftingTableTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void reset() {
            this.stacks = NonNullList.func_191197_a((int)17, (Object)ItemStack.field_190927_a);
        }

        public void readnbt(CompoundNBT nbt) {
            this.reset();
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks);
            while (this.stacks.size() < 17) {
                this.stacks.add((Object)ItemStack.field_190927_a);
            }
            this.history = nbt.func_74775_l("history");
        }

        private void writenbt(CompoundNBT nbt) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks);
            if (!this.history.isEmpty()) {
                nbt.func_218657_a("history", (INBT)this.history);
            }
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public CompoundNBT func_189517_E_() {
            CompoundNBT nbt = super.func_189517_E_();
            this.writenbt(nbt);
            return nbt;
        }

        @Nullable
        public SUpdateTileEntityPacket func_189518_D_() {
            return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
            super.func_145839_a(pkt.func_148857_g());
            this.readnbt(pkt.func_148857_g());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(CompoundNBT tag) {
            this.func_145839_a(tag);
        }

        @OnlyIn(value=Dist.CLIENT)
        public double func_145833_n() {
            return 400.0;
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Treated wood crafting table");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new CraftingTableContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
        }

        public int func_70302_i_() {
            return this.stacks.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks.set(index, (Object)stack);
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_174877_v().func_177951_i((Vec3i)player.func_180425_c()) < 36.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
            if (this.field_145850_b instanceof World) {
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public void func_174888_l() {
            this.stacks.clear();
        }
    }

    public static final class CraftingTableBlock
    extends DecorBlock.HorizontalWaterLoggable
    implements IDecorBlock {
        public CraftingTableBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new CraftingTableTileEntity();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof CraftingTableTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.SUCCESS;
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o()) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
                return;
            }
            CompoundNBT inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
            if (inventory_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof CraftingTableTileEntity)) {
                return;
            }
            ((CraftingTableTileEntity)te).readnbt(inventory_nbt);
            ((CraftingTableTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof CraftingTableTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT inventory_nbt = new CompoundNBT();
                ItemStackHelper.func_191281_a((CompoundNBT)inventory_nbt, ((CraftingTableTileEntity)te).stacks, (boolean)false);
                if (!inventory_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("inventory", (INBT)inventory_nbt);
                    stack.func_77982_d(nbt);
                }
                ((CraftingTableTileEntity)te).func_174888_l();
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((CraftingTableTileEntity)te).stacks) {
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
                ((CraftingTableTileEntity)te).reset();
            }
            return stacks;
        }
    }
}

