/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.network;

import com.chaosthedude.endermail.blocks.PackageBlock;
import com.chaosthedude.endermail.registry.EnderMailItems;
import com.chaosthedude.endermail.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class StampPackagePacket {
    private int packageX;
    private int packageY;
    private int packageZ;
    private int deliveryX;
    private int deliveryY;
    private int deliveryZ;
    private String lockerID;

    public StampPackagePacket() {
    }

    public StampPackagePacket(BlockPos packagePos, BlockPos deliveryPos, String lockerID) {
        this.packageX = packagePos.func_177958_n();
        this.packageY = packagePos.func_177956_o();
        this.packageZ = packagePos.func_177952_p();
        this.deliveryX = deliveryPos.func_177958_n();
        this.deliveryY = deliveryPos.func_177956_o();
        this.deliveryZ = deliveryPos.func_177952_p();
        this.lockerID = lockerID;
    }

    public StampPackagePacket(PacketBuffer buf) {
        this.packageX = buf.readInt();
        this.packageY = buf.readInt();
        this.packageZ = buf.readInt();
        this.deliveryX = buf.readInt();
        this.deliveryY = buf.readInt();
        this.deliveryZ = buf.readInt();
        this.lockerID = buf.func_150789_c(12);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.packageX);
        buf.writeInt(this.packageY);
        buf.writeInt(this.packageZ);
        buf.writeInt(this.deliveryX);
        buf.writeInt(this.deliveryY);
        buf.writeInt(this.deliveryZ);
        buf.func_180714_a(this.lockerID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PackageBlock.stampPackage(((NetworkEvent.Context)ctx.get()).getSender().field_70170_p, new BlockPos(this.packageX, this.packageY, this.packageZ), new BlockPos(this.deliveryX, this.deliveryY, this.deliveryZ), this.lockerID);
            ItemStack stampStack = ItemUtils.getHeldItem((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), EnderMailItems.STAMP);
            if (stampStack != null && !((NetworkEvent.Context)ctx.get()).getSender().func_184812_l_()) {
                stampStack.func_190920_e(stampStack.func_190916_E() - 1);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

