/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.item;

import com.tfar.metalbarrels.item.UpgradeInfo;
import com.tfar.metalbarrels.tile.AbstractBarrelTile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BarrelUpgradeItem
extends Item {
    protected final UpgradeInfo upgradeInfo;
    private static final ITextComponent s = new TranslationTextComponent("tooltip.metalbarrels.ironchest", new Object[0]).func_211708_a(TextFormatting.GREEN);
    public static boolean IRON_CHESTS_LOADED;

    public BarrelUpgradeItem(Item.Properties properties, UpgradeInfo info) {
        super(properties);
        this.upgradeInfo = info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (IRON_CHESTS_LOADED) {
            tooltip.add(s);
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack heldStack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        if (player == null || !this.upgradeInfo.canUpgrade(world.func_180495_p(pos).func_177230_c())) {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K || player.func_213283_Z() != Pose.CROUCHING) {
            return ActionResultType.PASS;
        }
        if (state.func_177230_c() instanceof BarrelBlock && ((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208193_t)).booleanValue()) {
            player.func_146105_b(new TranslationTextComponent("metalbarrels.in_use", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
            return ActionResultType.PASS;
        }
        TileEntity oldBarrel = world.func_175625_s(pos);
        ArrayList<ItemStack> oldBarrelContents = new ArrayList<ItemStack>();
        Direction facing = Direction.NORTH;
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        } else if (state.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        }
        if (oldBarrel instanceof AbstractBarrelTile) {
            oldBarrelContents.addAll(((AbstractBarrelTile)oldBarrel).handler.getContents());
        } else {
            oldBarrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).forEach(oldBarrelContents::add));
        }
        oldBarrel.func_145843_s();
        Block newBlock = this.upgradeInfo.getBlock(state.func_177230_c());
        BlockState newState = newBlock.func_176223_P();
        if (newState.func_196959_b((IProperty)BlockStateProperties.field_208157_J)) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)facing);
        } else if (newState.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing);
        }
        world.func_180501_a(pos, newState, 3);
        TileEntity newBarrel = world.func_175625_s(pos);
        newBarrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> IntStream.range(0, oldBarrelContents.size()).forEach(i -> itemHandler.insertItem(i, (ItemStack)oldBarrelContents.get(i), false)));
        if (!player.field_71075_bZ.field_75098_d) {
            heldStack.func_190918_g(1);
        }
        player.func_146105_b(new TranslationTextComponent("metalbarrels.upgrade_successful", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), true);
        return ActionResultType.SUCCESS;
    }
}

