/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.toolbox;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.tool.ToolPanel;
import vswe.stevesfactory.ui.manager.tool.group.GroupList;
import vswe.stevesfactory.ui.manager.toolbox.IconToolType;

public final class ToolboxPanel
extends DynamicWidthWidget<IWidget> {
    public static final TextureWrapper GROUP_LIST_ICON = TextureWrapper.ofGUITexture("tool_icon/group.png", 16, 16, 0, 0, 16, 16);
    private final IconToolType<GroupList> groupList;
    private final AbstractIconButton close;
    private final List<IWidget> children = new ArrayList<IWidget>();

    public ToolboxPanel() {
        super(DynamicWidthWidget.WidthOccupierType.MIN_WIDTH);
        this.setWidth(10);
        this.groupList = new IconToolType<GroupList>(GROUP_LIST_ICON, GroupList::new).setName(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.Name", (Object[])new Object[0]));
        this.addChildOnly(this.groupList);
        this.close = new AbstractIconButton(0, 0, 8, 8){

            @Override
            public void render(int mouseX, int mouseY, float particleTicks) {
                super.render(mouseX, mouseY, particleTicks);
                if (this.isInside(mouseX, mouseY)) {
                    WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Toolbox.CloseToolPanel", (Object[])new Object[0]), mouseX, mouseY);
                }
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                ToolPanel panel = FactoryManagerGUI.getActiveGUI().getPrimaryWindow().topLevel.toolPanel;
                panel.setActivePanel(null);
                return true;
            }

            @Override
            public TextureWrapper getTextureNormal() {
                return FactoryManagerGUI.CLOSE_ICON;
            }

            @Override
            public TextureWrapper getTextureHovered() {
                return FactoryManagerGUI.CLOSE_ICON_HOVERED;
            }

            @Override
            public BoxSizing getBoxSizing() {
                return BoxSizing.PHANTOM;
            }
        };
        this.addChildOnly(this.close);
    }

    @Override
    public List<IWidget> getChildren() {
        return this.children;
    }

    private void addChildOnly(IWidget widget) {
        this.children.add(widget);
        widget.setParentWidget(this);
    }

    public ToolboxPanel addChildren(IWidget widget) {
        this.addChildOnly(widget);
        this.reflow();
        return this;
    }

    public ToolboxPanel addChildren(Collection<IWidget> widgets) {
        this.children.addAll(widgets);
        for (IWidget widget : widgets) {
            widget.setParentWidget(this);
        }
        this.reflow();
        return this;
    }

    @Override
    public void reflow() {
        FlowLayout.vertical(this.children, 2, 0, 0);
        this.close.setX(RenderingHelper.getXForAlignedCenter(2, this.getWidth(), this.close.getWidth()));
        this.close.alignBottom(this.getHeight());
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderingHelper.renderSideLine(this);
        super.render(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY)) {
            if (button == 0) {
                this.getWindow().setFocusedWidget(this);
            } else if (button == 1) {
                this.openActionMenu();
            }
            return true;
        }
        return false;
    }

    private void openActionMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(null, "gui.sfm.FactoryManager.CtxMenu.ToggleFullscreen", b -> FactoryManagerGUI.getActiveGUI().getPrimaryWindow().toggleFullscreen())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }

    public GroupList getGroupList() {
        return this.groupList.getToolWindow();
    }
}

