/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import net.minecraft.client.gui.screen.Screen;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.library.gui.window.Dialog;

class OffsetText
extends AbstractWidget
implements LeafWidgetMixin {
    private final String prefix;
    private String text;
    private int value;
    public int rightX;

    public OffsetText(String prefix, int xRight, int y) {
        RenderingHelper.fontRenderer().getClass();
        super(xRight, y, 0, 9);
        this.text = "";
        this.prefix = prefix;
        this.set(0);
    }

    public String getText() {
        return this.text;
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value;
        this.text = this.prefix + value;
        this.update();
    }

    public void update() {
        int width = RenderingHelper.fontRenderer().func_78256_a(this.text);
        this.setWidth(width);
        this.setX(this.rightX - width);
    }

    public void add(int offset) {
        this.set(this.value + offset);
    }

    public void subtract(int offset) {
        this.set(this.value - offset);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        int color = this.isInside(mouseX, mouseY) ? 0xFFFF00 : 0xFFFFFF;
        RenderingHelper.fontRenderer().func_175063_a(this.text, (float)this.getAbsoluteX(), (float)this.getAbsoluteY(), color);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (Screen.hasControlDown()) {
                this.set(0);
            } else {
                Dialog.createPrompt("gui.sfm.FactoryManager.Editor.EditOffset", (b, s) -> {
                    try {
                        this.set(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        Dialog.createDialog("gui.sfm.FactoryManager.Editor.InvalidNumberFormat").tryAddSelfToActiveGUI();
                    }
                }).tryAddSelfToActiveGUI();
            }
            return true;
        }
        return false;
    }
}

