/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic.procedure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityDocuments;
import vswe.stevesfactory.api.capability.ITextDocument;
import vswe.stevesfactory.api.logic.IExecutionContext;
import vswe.stevesfactory.logic.AbstractProcedure;
import vswe.stevesfactory.logic.ModProcedures;
import vswe.stevesfactory.logic.procedure.IInventoryTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.menu.InventorySelectionMenu;
import vswe.stevesfactory.ui.manager.menu.SignUpdaterLinesMenu;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;

public class SignUpdaterProcedure
extends AbstractProcedure
implements IInventoryTarget {
    public static final int SIGNS = 0;
    private List<BlockPos> signs = new ArrayList<BlockPos>();
    private String[] texts = new String[4];
    private transient List<LazyOptional<ITextDocument>> cachedCaps = new ArrayList<LazyOptional<ITextDocument>>();
    private transient boolean dirty = false;

    public SignUpdaterProcedure() {
        super(ModProcedures.signUpdater);
        Arrays.fill(this.texts, "");
    }

    @Override
    public void execute(IExecutionContext context) {
        this.pushFrame(context, 0);
        this.updateCaches(context);
        for (LazyOptional<ITextDocument> cap : this.cachedCaps) {
            cap.ifPresent(display -> {
                for (int i = 0; i < this.texts.length; ++i) {
                    display.setLine(i, (ITextComponent)new StringTextComponent(this.texts[i]));
                }
            });
        }
    }

    private void updateCaches(IExecutionContext context) {
        if (!this.dirty) {
            return;
        }
        this.cachedCaps.clear();
        NetworkHelper.cacheCaps(context, this.cachedCaps, this.signs, CapabilityDocuments.TEXT_DISPLAY_CAPABILITY, __ -> this.markDirty());
        this.dirty = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FlowComponent<SignUpdaterProcedure> createFlowComponent() {
        FlowComponent<SignUpdaterProcedure> f = FlowComponent.of(this);
        f.addMenu(new InventorySelectionMenu(0, I18n.func_135052_a((String)"menu.sfm.SignUpdater.Signs", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.SignUpdater.NoTargets", (Object[])new Object[0]), CapabilityDocuments.TEXT_DISPLAY_CAPABILITY));
        f.addMenu(new SignUpdaterLinesMenu());
        return f;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        tag.func_218657_a("Signs", (INBT)IOHelper.writeBlockPoses(this.signs));
        tag.func_218657_a("Texts", (INBT)IOHelper.writeStrings(this.texts));
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.signs.clear();
        IOHelper.readBlockPoses(tag.func_150295_c("Signs", 10), this.signs);
        IOHelper.readStrings(tag.func_150295_c("Texts", 8), this.texts);
        this.markDirty();
    }

    @Override
    public List<BlockPos> getInventories(int id) {
        return this.signs;
    }

    public String[] getTexts() {
        return this.texts;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }
}

