/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.ITrackableContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileComponentConfig
implements ITileComponent,
ITrackableContainer {
    public TileEntityMekanism tile;
    private Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private List<TransmissionType> transmissionTypes = new ArrayList<TransmissionType>();

    public TileComponentConfig(TileEntityMekanism tile, TransmissionType ... types) {
        this.tile = tile;
        for (TransmissionType type : types) {
            this.addSupported(type);
        }
        tile.addComponent(this);
    }

    public void sideChanged(TransmissionType transmissionType, RelativeSide side) {
        Direction direction = side.getDirection(this.tile.getDirection());
        switch (transmissionType) {
            case ENERGY: {
                this.tile.invalidateCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities(), direction);
                break;
            }
            case FLUID: {
                this.tile.invalidateCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
                break;
            }
            case GAS: {
                this.tile.invalidateCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction);
                break;
            }
            case ITEM: {
                this.tile.invalidateCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
                break;
            }
            case HEAT: {
                this.tile.invalidateCapability(Capabilities.HEAT_HANDLER_CAPABILITY, direction);
            }
        }
        this.tile.sendUpdatePacket();
        this.tile.markDirty(false);
        MekanismUtils.notifyNeighborOfChange(this.tile.func_145831_w(), direction, this.tile.func_174877_v());
    }

    private RelativeSide getSide(Direction direction) {
        return RelativeSide.fromDirections(this.tile.getDirection(), direction);
    }

    public List<TransmissionType> getTransmissions() {
        return this.transmissionTypes;
    }

    public void addSupported(TransmissionType type) {
        if (!this.configInfo.containsKey(type)) {
            this.configInfo.put(type, new ConfigInfo(() -> this.tile.getDirection()));
            this.transmissionTypes.add(type);
        }
    }

    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, Direction side) {
        ConfigInfo info;
        TransmissionType type = null;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            type = TransmissionType.ITEM;
        } else if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            type = TransmissionType.GAS;
        } else if (capability == Capabilities.HEAT_HANDLER_CAPABILITY) {
            type = TransmissionType.HEAT;
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            type = TransmissionType.FLUID;
        } else if (EnergyCompatUtils.isEnergyCapability(capability)) {
            type = TransmissionType.ENERGY;
        }
        if (type != null && (info = this.getConfig(type)) != null && side != null) {
            ISlotInfo slotInfo = info.getSlotInfo(this.getSide(side));
            return slotInfo == null || !slotInfo.isEnabled();
        }
        return false;
    }

    @Nullable
    public ConfigInfo getConfig(TransmissionType type) {
        return this.configInfo.get(type);
    }

    @Nullable
    public DataType getDataType(TransmissionType type, RelativeSide side) {
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getDataType(side);
    }

    @Nullable
    public ISlotInfo getSlotInfo(TransmissionType type, Direction direction) {
        if (direction == null) {
            return null;
        }
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getSlotInfo(this.getSide(direction));
    }

    public boolean supports(TransmissionType type) {
        return this.configInfo.containsKey(type);
    }

    @Override
    public void tick() {
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentConfig", 10)) {
            CompoundNBT configNBT = nbtTags.func_74775_l("componentConfig");
            for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
                TransmissionType type = entry.getKey();
                ConfigInfo info = entry.getValue();
                info.setEjecting(configNBT.func_74767_n("eject" + type.ordinal()));
                CompoundNBT sideConfig = configNBT.func_74775_l("config" + type.ordinal());
                for (RelativeSide side : EnumUtils.SIDES) {
                    NBTUtils.setEnumIfPresent(sideConfig, "side" + side.ordinal(), DataType::byIndexStatic, dataType -> info.setDataType(side, (DataType)dataType));
                }
            }
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT configNBT = new CompoundNBT();
        for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            ConfigInfo info = entry.getValue();
            configNBT.func_74757_a("eject" + type.ordinal(), info.isEjecting());
            CompoundNBT sideConfig = new CompoundNBT();
            for (RelativeSide side : EnumUtils.SIDES) {
                sideConfig.func_74768_a("side" + side.ordinal(), info.getDataType(side).ordinal());
            }
            configNBT.func_218657_a("config" + type.ordinal(), (INBT)sideConfig);
        }
        nbtTags.func_218657_a("componentConfig", (INBT)configNBT);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
        CompoundNBT configNBT = new CompoundNBT();
        for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            ConfigInfo info = entry.getValue();
            CompoundNBT sideConfig = new CompoundNBT();
            for (RelativeSide side : EnumUtils.SIDES) {
                sideConfig.func_74768_a("side" + side.ordinal(), info.getDataType(side).ordinal());
            }
            configNBT.func_218657_a("config" + type.ordinal(), (INBT)sideConfig);
        }
        updateTag.func_218657_a("componentConfig", (INBT)configNBT);
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
        if (updateTag.func_150297_b("componentConfig", 10)) {
            CompoundNBT configNBT = updateTag.func_74775_l("componentConfig");
            for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
                TransmissionType type = entry.getKey();
                ConfigInfo info = entry.getValue();
                CompoundNBT sideConfig = configNBT.func_74775_l("config" + type.ordinal());
                for (RelativeSide side : EnumUtils.SIDES) {
                    NBTUtils.setEnumIfPresent(sideConfig, "side" + side.ordinal(), DataType::byIndexStatic, dataType -> info.setDataType(side, (DataType)dataType));
                }
            }
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        List<TransmissionType> transmissions = this.getTransmissions();
        for (TransmissionType transmission : transmissions) {
            ConfigInfo info = this.configInfo.get(transmission);
            container.track(SyncableBoolean.create(info::isEjecting, info::setEjecting));
        }
    }
}

