/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityBoundingBlock
extends TileEntityUpdateable {
    private BlockPos mainPos = BlockPos.field_177992_a;
    public boolean receivedCoords;
    private int currentRedstoneLevel;

    public TileEntityBoundingBlock() {
        this(MekanismTileEntityTypes.BOUNDING_BLOCK.getTileEntityType());
    }

    public TileEntityBoundingBlock(TileEntityType<TileEntityBoundingBlock> type) {
        super(type);
    }

    public void setMainLocation(BlockPos pos) {
        boolean bl = this.receivedCoords = pos != null;
        if (!this.isRemote()) {
            this.mainPos = pos;
            this.sendUpdatePacket();
        }
    }

    public BlockPos getMainPos() {
        if (this.mainPos == null) {
            this.mainPos = BlockPos.field_177992_a;
        }
        return this.mainPos;
    }

    @Nullable
    public TileEntity getMainTile() {
        return this.receivedCoords ? MekanismUtils.getTileEntity((IBlockReader)this.field_145850_b, this.getMainPos()) : null;
    }

    public void onNeighborChange(BlockState state) {
        int power;
        TileEntity tile = this.getMainTile();
        if (tile instanceof TileEntityMekanism && this.currentRedstoneLevel != (power = this.field_145850_b.func_175687_A(this.func_174877_v()))) {
            if (power > 0) {
                this.onPower();
            } else {
                this.onNoPower();
            }
            this.currentRedstoneLevel = power;
            ((TileEntityMekanism)tile).sendUpdatePacket(this);
        }
    }

    public void onPower() {
    }

    public void onNoPower() {
    }

    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setBlockPosIfPresent(nbtTags, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = nbtTags.func_74762_e("redstone");
        this.receivedCoords = nbtTags.func_74767_n("receivedCoords");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        nbtTags.func_74768_a("redstone", this.currentRedstoneLevel);
        nbtTags.func_74757_a("receivedCoords", this.receivedCoords);
        return nbtTags;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("main", (INBT)NBTUtil.func_186859_a((BlockPos)this.getMainPos()));
        updateTag.func_74768_a("redstone", this.currentRedstoneLevel);
        updateTag.func_74757_a("receivedCoords", this.receivedCoords);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBlockPosIfPresent(tag, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = tag.func_74762_e("redstone");
        this.receivedCoords = tag.func_74767_n("receivedCoords");
    }
}

