/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.states.IStateStorage;
import mekanism.common.tile.TileEntityCardboardBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.Contract;

public class BlockStateHelper {
    public static final DirectionProperty facingProperty = BlockStateProperties.field_208155_H;
    public static final DirectionProperty horizontalFacingProperty = BlockStateProperties.field_208157_J;
    public static final BooleanProperty activeProperty = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty storageProperty = BooleanProperty.func_177716_a((String)"storage");
    public static final BooleanProperty FLUID_LOGGED = BlockStateProperties.field_208198_y;

    public static BlockState getDefaultState(@Nonnull BlockState state) {
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeStateActive.class)) {
            state = (BlockState)state.func_206870_a((IProperty)activeProperty, (Comparable)Boolean.valueOf(false));
        }
        if (block instanceof IStateFluidLoggable) {
            state = (BlockState)state.func_206870_a((IProperty)FLUID_LOGGED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static void fillBlockStateContainer(Block block, StateContainer.Builder<Block, BlockState> builder) {
        ArrayList<BooleanProperty> properties = new ArrayList<BooleanProperty>();
        Attribute.ifHas(block, AttributeStateFacing.class, attr -> properties.add((BooleanProperty)attr.getFacingProperty()));
        if (Attribute.has(block, AttributeStateActive.class)) {
            properties.add(activeProperty);
        }
        if (block instanceof IStateStorage) {
            properties.add(storageProperty);
        }
        if (block instanceof IStateFluidLoggable) {
            properties.add(FLUID_LOGGED);
        }
        if (!properties.isEmpty()) {
            builder.func_206894_a(properties.toArray(new IProperty[0]));
        }
    }

    @Contract(value="_, null, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, BlockItemUseContext context) {
        return BlockStateHelper.getStateForPlacement(block, state, (IWorld)context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), context.func_196000_l());
    }

    @Contract(value="_, null, _, _, _, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nullable PlayerEntity player, @Nonnull Direction face) {
        if (state == null) {
            return null;
        }
        if (Attribute.has(block, AttributeStateFacing.class)) {
            AttributeStateFacing blockFacing = Attribute.get(block, AttributeStateFacing.class);
            Direction newDirection = Direction.SOUTH;
            if (blockFacing.getPlacementType() == AttributeStateFacing.FacePlacementType.PLAYER_LOCATION) {
                if (blockFacing.supportsDirection(Direction.DOWN) && blockFacing.supportsDirection(Direction.UP)) {
                    float rotationPitch = player == null ? 0.0f : player.field_70125_A;
                    int height = Math.round(rotationPitch);
                    if (height >= 65) {
                        newDirection = Direction.UP;
                    } else if (height <= -65) {
                        newDirection = Direction.DOWN;
                    }
                }
                if (newDirection != Direction.DOWN && newDirection != Direction.UP) {
                    float placementYaw = player == null ? 0.0f : player.field_70177_z;
                    int side = MathHelper.func_76128_c((double)((double)(placementYaw * 4.0f / 360.0f) + 0.5)) & 3;
                    switch (side) {
                        case 0: {
                            newDirection = Direction.NORTH;
                            break;
                        }
                        case 1: {
                            newDirection = Direction.EAST;
                            break;
                        }
                        case 2: {
                            newDirection = Direction.SOUTH;
                            break;
                        }
                        case 3: {
                            newDirection = Direction.WEST;
                        }
                    }
                }
            } else {
                newDirection = blockFacing.supportsDirection(face) ? face : Direction.NORTH;
            }
            state = blockFacing.setDirection(state, newDirection);
        }
        if (block instanceof IStateFluidLoggable) {
            IFluidState fluidState = world.func_204610_c(pos);
            state = (BlockState)state.func_206870_a((IProperty)FLUID_LOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        }
        return state;
    }

    public static BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return BlockStateHelper.rotate(state, rotation);
    }

    public static BlockState rotate(BlockState state, Rotation rotation) {
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeStateFacing.class)) {
            AttributeStateFacing blockFacing = Attribute.get(block, AttributeStateFacing.class);
            return BlockStateHelper.rotate(blockFacing, blockFacing.getFacingProperty(), state, rotation);
        }
        return state;
    }

    public static BlockState mirror(BlockState state, Mirror mirror) {
        Block block = state.func_177230_c();
        if (Attribute.has(block, AttributeStateFacing.class)) {
            AttributeStateFacing blockFacing = Attribute.get(block, AttributeStateFacing.class);
            DirectionProperty property = blockFacing.getFacingProperty();
            return BlockStateHelper.rotate(blockFacing, property, state, mirror.func_185800_a((Direction)state.func_177229_b((IProperty)property)));
        }
        return state;
    }

    private static BlockState rotate(AttributeStateFacing blockFacing, DirectionProperty property, BlockState state, Rotation rotation) {
        return blockFacing.setDirection(state, rotation.func_185831_a((Direction)state.func_177229_b((IProperty)property)));
    }

    private static boolean isStoring(@Nonnull TileEntity tile) {
        if (tile instanceof TileEntityCardboardBox) {
            return ((TileEntityCardboardBox)tile).storedData != null;
        }
        return false;
    }

    public static BlockState copyStateData(BlockState oldState, BlockState newState) {
        Block newBlock;
        Block oldBlock = oldState.func_177230_c();
        if (Attribute.has(oldBlock, newBlock = newState.func_177230_c(), AttributeStateFacing.class)) {
            newState = (BlockState)newState.func_206870_a((IProperty)Attribute.get(newBlock, AttributeStateFacing.class).getFacingProperty(), oldState.func_177229_b((IProperty)Attribute.get(oldBlock, AttributeStateFacing.class).getFacingProperty()));
        }
        if (Attribute.has(oldBlock, newBlock, AttributeStateActive.class)) {
            newState = (BlockState)newState.func_206870_a((IProperty)activeProperty, oldState.func_177229_b((IProperty)activeProperty));
        }
        if (oldBlock instanceof IStateStorage && newBlock instanceof IStateStorage) {
            newState = (BlockState)newState.func_206870_a((IProperty)storageProperty, oldState.func_177229_b((IProperty)storageProperty));
        }
        if (oldBlock instanceof IStateFluidLoggable && newBlock instanceof IStateFluidLoggable) {
            newState = (BlockState)newState.func_206870_a((IProperty)FLUID_LOGGED, oldState.func_177229_b((IProperty)FLUID_LOGGED));
        }
        return newState;
    }
}

