/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.data.ModelProperties;
import mekanism.client.render.obj.TransmitterModelConfiguration;
import mekanism.client.render.obj.TransmitterModelTransform;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.obj.OBJModel;

public class TransmitterBakedModel
implements IBakedModel {
    private final OBJModel internal;
    @Nullable
    private final OBJModel glass;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ItemOverrideList overrides;
    private final ResourceLocation modelLocation;
    private final IBakedModel bakedVariant;
    private Int2ObjectMap<List<BakedQuad>> modelCache;

    public TransmitterBakedModel(OBJModel internal, @Nullable OBJModel glass, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.modelCache = new Int2ObjectOpenHashMap(glass == null ? 4096 : 8192);
        this.internal = internal;
        this.glass = glass;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.modelLocation = modelLocation;
        List<String> visible = Arrays.stream(EnumUtils.DIRECTIONS).map(side -> side.func_176610_l() + (side.func_176740_k() == Direction.Axis.Y ? "NORMAL" : "NONE")).collect(Collectors.toList());
        this.bakedVariant = internal.bake((IModelConfiguration)new VisibleModelConfiguration(owner, visible), bakery, spriteGetter, modelTransform, overrides, modelLocation);
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (extraData.hasProperty(ModelProperties.DOWN_CONNECTION) && extraData.hasProperty(ModelProperties.UP_CONNECTION) && extraData.hasProperty(ModelProperties.NORTH_CONNECTION) && extraData.hasProperty(ModelProperties.SOUTH_CONNECTION) && extraData.hasProperty(ModelProperties.WEST_CONNECTION) && extraData.hasProperty(ModelProperties.EAST_CONNECTION)) {
            TileEntitySidedPipe.ConnectionType down = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.DOWN_CONNECTION);
            TileEntitySidedPipe.ConnectionType up = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.UP_CONNECTION);
            TileEntitySidedPipe.ConnectionType north = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.NORTH_CONNECTION);
            TileEntitySidedPipe.ConnectionType south = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.SOUTH_CONNECTION);
            TileEntitySidedPipe.ConnectionType west = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.WEST_CONNECTION);
            TileEntitySidedPipe.ConnectionType east = (TileEntitySidedPipe.ConnectionType)extraData.getData(ModelProperties.EAST_CONNECTION);
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            boolean hasColor = false;
            if (extraData.hasProperty(ModelProperties.COLOR) && layer == RenderType.func_228645_f_()) {
                Boolean color = (Boolean)extraData.getData(ModelProperties.COLOR);
                hasColor = color != null && color != false;
            }
            int hash = 1;
            hash = hash * 31 + down.ordinal();
            hash = hash * 31 + up.ordinal();
            hash = hash * 31 + north.ordinal();
            hash = hash * 31 + south.ordinal();
            hash = hash * 31 + west.ordinal();
            hash = hash * 31 + east.ordinal();
            if (hasColor) {
                hash = hash * 31 + 1;
            }
            if (!this.modelCache.containsKey(hash)) {
                ArrayList<String> visible = new ArrayList<String>();
                visible.add(Direction.DOWN.func_176610_l() + down.func_176610_l().toUpperCase());
                visible.add(Direction.UP.func_176610_l() + up.func_176610_l().toUpperCase());
                visible.add(Direction.NORTH.func_176610_l() + north.func_176610_l().toUpperCase());
                visible.add(Direction.SOUTH.func_176610_l() + south.func_176610_l().toUpperCase());
                visible.add(Direction.WEST.func_176610_l() + west.func_176610_l().toUpperCase());
                visible.add(Direction.EAST.func_176610_l() + east.func_176610_l().toUpperCase());
                List result = this.bake(new TransmitterModelConfiguration(this.owner, visible, extraData), hasColor).getQuads(state, side, rand, extraData);
                this.modelCache.put(hash, (Object)result);
                return result;
            }
            return (List)this.modelCache.get(hash);
        }
        return this.bakedVariant.getQuads(state, side, rand, extraData);
    }

    private IBakedModel bake(TransmitterModelConfiguration configuration, boolean hasColor) {
        TextureAtlasSprite particle = this.spriteGetter.apply(configuration.resolveTexture("particle"));
        IModelBuilder builder = IModelBuilder.of((IModelConfiguration)configuration, (ItemOverrideList)this.overrides, (TextureAtlasSprite)particle);
        this.addPartQuads(configuration, builder, this.internal);
        if (this.glass != null && hasColor && MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_()) {
            this.addPartQuads(configuration, builder, this.glass);
        }
        return builder.build();
    }

    private void addPartQuads(TransmitterModelConfiguration configuration, IModelBuilder<?> builder, OBJModel glass) {
        for (IModelGeometryPart part : glass.getParts()) {
            if (!configuration.getPartVisibility(part)) continue;
            String name = part.name();
            IModelTransform transform = this.modelTransform;
            if (name.endsWith("NONE")) {
                Direction dir = TransmitterBakedModel.directionForPiece(name);
                TransmitterModelConfiguration.IconStatus status = configuration.getIconStatus(dir);
                if (dir != null && status.getAngle() > 0.0f) {
                    transform = new TransmitterModelTransform(transform, dir, status.getAngle());
                }
            }
            part.addQuads((IModelConfiguration)configuration, builder, this.bakery, this.spriteGetter, transform, this.modelLocation);
        }
    }

    @Nullable
    private static Direction directionForPiece(@Nonnull String piece) {
        if (piece.startsWith("down")) {
            return Direction.DOWN;
        }
        if (piece.startsWith("up")) {
            return Direction.UP;
        }
        if (piece.startsWith("north")) {
            return Direction.NORTH;
        }
        if (piece.startsWith("south")) {
            return Direction.SOUTH;
        }
        if (piece.startsWith("east")) {
            return Direction.EAST;
        }
        if (piece.startsWith("west")) {
            return Direction.WEST;
        }
        return null;
    }

    public boolean func_177555_b() {
        return this.bakedVariant.func_177555_b();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.bakedVariant.isAmbientOcclusion(state);
    }

    public boolean func_177556_c() {
        return this.bakedVariant.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.bakedVariant.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.bakedVariant.func_188618_c();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite func_177554_e() {
        return this.bakedVariant.func_177554_e();
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.bakedVariant.getParticleTexture(data);
    }

    public boolean doesHandlePerspectives() {
        return this.bakedVariant.doesHandlePerspectives();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        return this.bakedVariant.handlePerspective(cameraTransformType, mat);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.bakedVariant.func_188617_f();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return this.bakedVariant.getModelData(world, pos, state, tileData);
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.bakedVariant.func_177552_f();
    }
}

