/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public class FilterSelectButton
extends MekanismButton {
    private static final ResourceLocation ARROWS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "filter_arrows.png");
    private static final int TEXTURE_WIDTH = 22;
    private static final int TEXTURE_HEIGHT = 14;
    private final boolean down;

    public FilterSelectButton(IGuiWrapper gui, int x, int y, boolean down, Runnable onPress, GuiElement.IHoverable onHover) {
        super(gui, x, y, 11, 7, "", onPress, onHover);
        this.down = down;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int width = this.getButtonWidth();
        int height = this.getButtonHeight();
        int x = this.getButtonX();
        int y = this.getButtonY();
        MekanismRenderer.bindTexture(ARROWS);
        FilterSelectButton.blit((int)x, (int)y, (float)(this.isMouseOver(mouseX, mouseY) ? (float)width : 0.0f), (float)(this.down ? 7.0f : 0.0f), (int)width, (int)height, (int)22, (int)14);
        RenderSystem.disableBlend();
    }

    public boolean isMouseOver(double xAxis, double yAxis) {
        if (super.isMouseOver(xAxis, yAxis)) {
            double xShifted = xAxis - (double)this.x;
            double yShifted = yAxis - (double)this.y;
            if (this.down) {
                if (yShifted < 2.0) {
                    return true;
                }
                if (yShifted < 3.0) {
                    return xShifted >= 1.0 && xShifted < 10.0;
                }
                if (yShifted < 4.0) {
                    return xShifted >= 2.0 && xShifted < 9.0;
                }
                if (yShifted < 5.0) {
                    return xShifted >= 3.0 && xShifted < 8.0;
                }
                if (yShifted < 6.0) {
                    return xShifted >= 4.0 && xShifted < 7.0;
                }
                return xShifted >= 5.0 && xShifted < 6.0;
            }
            if (yShifted < 1.0) {
                return xShifted >= 5.0 && xShifted < 6.0;
            }
            if (yShifted < 2.0) {
                return xShifted >= 4.0 && xShifted < 7.0;
            }
            if (yShifted < 3.0) {
                return xShifted >= 3.0 && xShifted < 8.0;
            }
            if (yShifted < 4.0) {
                return xShifted >= 2.0 && xShifted < 9.0;
            }
            if (yShifted < 5.0) {
                return xShifted >= 1.0 && xShifted < 10.0;
            }
            return true;
        }
        return false;
    }
}

