/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiThermoelectricBoiler
extends GuiMekanismTile<TileEntityBoilerCasing, MekanismTileContainer<TileEntityBoilerCasing>> {
    public GuiThermoelectricBoiler(MekanismTileContainer<TileEntityBoilerCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 40, 27, 96, 32));
        this.addButton(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.STAT));
        this.addButton(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.BOIL_RATE.translate(((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getLastBoilRate());
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getLastBoilRate() / (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getLastMaxBoil();
            }
        }, 24, 13));
        this.addButton(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.MAX_BOIL_RATE.translate(((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getLastMaxBoil());
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getLastMaxBoil() * HeatUtils.getVaporizationEnthalpy() / ((double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tile).getSuperheatingElements() * MekanismConfig.general.superheatingHeatTransfer.get());
            }
        }, 144, 13));
        this.addButton(new GuiFluidGauge(() -> ((TileEntityBoilerCasing)this.tile).structure == null ? null : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).waterTank, () -> ((TileEntityBoilerCasing)this.tile).structure == null ? Collections.emptyList() : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).getFluidTanks(null), GaugeType.STANDARD, this, 6, 13));
        this.addButton(new GuiGasGauge(() -> ((TileEntityBoilerCasing)this.tile).structure == null ? null : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).steamTank, () -> ((TileEntityBoilerCasing)this.tile).structure == null ? Collections.emptyList() : ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tile).structure).getGasTanks(null), GaugeType.STANDARD, this, 152, 13));
        this.addButton(new GuiHeatInfo(() -> {
            ITextComponent environment = MekanismUtils.getTemperatureDisplay(((TileEntityBoilerCasing)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }, this));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 4, 0x404040);
        this.drawString(((TileEntityBoilerCasing)this.tile).getName(), this.getXSize() / 2 - this.getStringWidth(((TileEntityBoilerCasing)this.tile).getName()) / 2, 5, 0x404040);
        this.renderScaledText((ITextComponent)MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((TileEntityBoilerCasing)this.tile).getTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), 43, 30, 52480, 90);
        this.renderScaledText((ITextComponent)MekanismLang.BOIL_RATE.translate(((TileEntityBoilerCasing)this.tile).getLastBoilRate()), 43, 39, 52480, 90);
        this.renderScaledText((ITextComponent)MekanismLang.MAX_BOIL_RATE.translate(((TileEntityBoilerCasing)this.tile).getLastMaxBoil()), 43, 48, 52480, 90);
        super.func_146979_b(mouseX, mouseY);
    }
}

