/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class InputHelper {
    public static IInputHandler<@NonNull ItemStack> getInputHandler(final IInventorySlot inventorySlot) {
        return new IInputHandler<ItemStack>(){

            @Override
            @Nonnull
            public ItemStack getInput() {
                return inventorySlot.getStack();
            }

            @Override
            @Nonnull
            public ItemStack getRecipeInput(InputIngredient<@NonNull ItemStack> recipeIngredient) {
                ItemStack input = this.getInput();
                if (input.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(@Nonnull ItemStack recipeInput, int operations) {
                if (operations == 0) {
                    return;
                }
                if (!recipeInput.func_190926_b()) {
                    int amount = recipeInput.func_190916_E() * operations;
                    InputHelper.logMismatchedStackSize(inventorySlot.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public int operationsCanSupport(InputIngredient<@NonNull ItemStack> recipeIngredient, int currentMax, int usageMultiplier) {
                if (currentMax <= 0 || usageMultiplier == 0) {
                    return currentMax;
                }
                ItemStack recipeInput = this.getRecipeInput(recipeIngredient);
                if (recipeInput.func_190926_b()) {
                    return 0;
                }
                return Math.min(this.getInput().func_190916_E() / (recipeInput.func_190916_E() * usageMultiplier), currentMax);
            }
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ILongInputHandler<@NonNull STACK> getInputHandler(final IChemicalTank<CHEMICAL, STACK> tank) {
        return new ILongInputHandler<STACK>(){

            @Override
            @Nonnull
            public STACK getInput() {
                return tank.getStack();
            }

            @Override
            @Nonnull
            public STACK getRecipeInput(InputIngredient<@NonNull STACK> recipeIngredient) {
                Object input = this.getInput();
                if (((ChemicalStack)input).isEmpty()) {
                    return tank.getEmptyStack();
                }
                return (ChemicalStack)recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(@Nonnull STACK recipeInput, long operations) {
                if (operations == 0L) {
                    return;
                }
                if (((ChemicalStack)recipeInput).isEmpty()) {
                    return;
                }
                Object inputGas = this.getInput();
                if (!((ChemicalStack)inputGas).isEmpty()) {
                    long amount = ((ChemicalStack)recipeInput).getAmount() * operations;
                    InputHelper.logMismatchedStackSize(tank.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public int operationsCanSupport(InputIngredient<@NonNull STACK> recipeIngredient, int currentMax, long usageMultiplier) {
                if (currentMax <= 0 || usageMultiplier == 0L) {
                    return currentMax;
                }
                Object recipeInput = this.getRecipeInput(recipeIngredient);
                if (((ChemicalStack)recipeInput).isEmpty()) {
                    return 0;
                }
                return Math.min(MathUtils.clampToInt(((ChemicalStack)this.getInput()).getAmount() / (((ChemicalStack)recipeInput).getAmount() * usageMultiplier)), currentMax);
            }
        };
    }

    public static IInputHandler<@NonNull FluidStack> getInputHandler(final IExtendedFluidTank fluidTank) {
        return new IInputHandler<FluidStack>(){

            @Override
            @Nonnull
            public FluidStack getInput() {
                return fluidTank.getFluid();
            }

            @Override
            @Nonnull
            public FluidStack getRecipeInput(InputIngredient<@NonNull FluidStack> recipeIngredient) {
                FluidStack input = this.getInput();
                if (input.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(@Nonnull FluidStack recipeInput, int operations) {
                if (operations == 0) {
                    return;
                }
                if (recipeInput.isEmpty()) {
                    return;
                }
                FluidStack inputFluid = this.getInput();
                if (!inputFluid.isEmpty()) {
                    int amount = recipeInput.getAmount() * operations;
                    InputHelper.logMismatchedStackSize(fluidTank.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public int operationsCanSupport(InputIngredient<@NonNull FluidStack> recipeIngredient, int currentMax, int usageMultiplier) {
                if (currentMax <= 0 || usageMultiplier == 0) {
                    return currentMax;
                }
                FluidStack recipeInput = this.getRecipeInput(recipeIngredient);
                if (recipeInput.isEmpty()) {
                    return 0;
                }
                return Math.min(this.getInput().getAmount() / (recipeInput.getAmount() * usageMultiplier), currentMax);
            }
        };
    }

    private static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            MekanismAPI.logger.error("Stack size changed by a different amount (" + actual + ") than requested (" + expected + ").", (Throwable)new Exception());
        }
    }
}

