/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.registry;

import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.TemplateItem;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPasteContainerCreative;
import com.direwolf20.buildinggadgets.common.items.pastes.RegularPasteContainerTypes;
import com.direwolf20.buildinggadgets.common.registry.Registries;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class OurItems {
    @ObjectHolder(value="buildinggadgets:gadget_building")
    public static GadgetBuilding gadgetBuilding;
    @ObjectHolder(value="buildinggadgets:gadget_copy_paste")
    public static GadgetCopyPaste gadgetCopyPaste;
    @ObjectHolder(value="buildinggadgets:gadget_exchanging")
    public static GadgetExchanger gadgetExchanger;
    @ObjectHolder(value="buildinggadgets:gadget_destruction")
    public static GadgetDestruction gadgetDestruction;
    @ObjectHolder(value="buildinggadgets:construction_paste")
    public static ConstructionPaste constructionPaste;
    @ObjectHolder(value="buildinggadgets:construction_chunk_dense")
    public static Item constructionChunkDense;
    @ObjectHolder(value="buildinggadgets:template")
    public static TemplateItem template;
    @ObjectHolder(value="buildinggadgets:construction_paste_container_t1")
    public static ConstructionPasteContainer constructionPasteContainerT1;
    @ObjectHolder(value="buildinggadgets:construction_paste_container_t2")
    public static ConstructionPasteContainer constructionPasteContainerT2;
    @ObjectHolder(value="buildinggadgets:construction_paste_container_t3")
    public static ConstructionPasteContainer constructionPasteContainerT3;
    @ObjectHolder(value="buildinggadgets:construction_paste_container_creative")
    public static ConstructionPasteContainerCreative creativeConstructionPasteContainer;
    private static Set<Builder> itemBuilders;

    private OurItems() {
    }

    public static void setup() {
        itemBuilders.addAll((Collection<Builder>)new HashSet<Builder>(){
            {
                this.add(new Builder(Reference.ItemReference.GADGET_BUILDING_RL).setBuilder(OurItems.nonStackableItemProperties().func_200918_c(1)).setFactory(p -> new GadgetBuilding((Item.Properties)p, () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_BUILDING.undoSize).get(), "buildinggadgets_undo_building")));
                this.add(new Builder(Reference.ItemReference.GADGET_EXCHANGING_RL).setBuilder(OurItems.nonStackableItemProperties().func_200918_c(1)).setFactory(p -> new GadgetExchanger((Item.Properties)p, () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_EXCHANGER.undoSize).get(), "buildinggadgets_undo_exchanging")));
                this.add(new Builder(Reference.ItemReference.GADGET_COPY_PASTE_RL).setBuilder(OurItems.nonStackableItemProperties().func_200918_c(1)).setFactory(p -> new GadgetCopyPaste((Item.Properties)p, () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_COPY_PASTE.undoSize).get(), "buildinggadgets_undo_copy_paste")));
                this.add(new Builder(Reference.ItemReference.GADGET_DESTRUCTION_RL).setBuilder(OurItems.nonStackableItemProperties().func_200918_c(1)).setFactory(p -> new GadgetDestruction((Item.Properties)p, () -> ((ForgeConfigSpec.IntValue)Config.GADGETS.GADGET_DESTRUCTION.undoSize).get(), "buildinggadgets_undo_destruction")));
                this.add(new Builder(Reference.ItemReference.PASTE_CONTAINER_T1_RL).setBuilder(OurItems.nonStackableItemProperties()).setFactory(RegularPasteContainerTypes.T1::create));
                this.add(new Builder(Reference.ItemReference.PASTE_CONTAINER_T2_RL).setBuilder(OurItems.nonStackableItemProperties()).setFactory(RegularPasteContainerTypes.T2::create));
                this.add(new Builder(Reference.ItemReference.PASTE_CONTAINER_T3_RL).setBuilder(OurItems.nonStackableItemProperties()).setFactory(RegularPasteContainerTypes.T3::create));
                this.add(new Builder(Reference.ItemReference.PASTE_CONTAINER_CREATIVE_RL).setBuilder(OurItems.nonStackableItemProperties()).setFactory(ConstructionPasteContainerCreative::new));
                this.add(new Builder(Reference.ItemReference.CONSTRUCTION_PASTE_RL).setBuilder(OurItems.itemProperties()).setFactory(ConstructionPaste::new));
                this.add(new Builder(Reference.ItemReference.CONSTRUCTION_CHUNK_DENSE_RL).setBuilder(OurItems.itemProperties()).setFactory(Item::new));
                this.add(new Builder(Reference.ItemReference.TEMPLATE_RL).setBuilder(OurItems.itemProperties()).setFactory(TemplateItem::new));
            }
        });
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        itemBuilders.forEach(e -> event.getRegistry().register((IForgeRegistryEntry)((Builder)e).createItem()));
        itemBuilders.clear();
    }

    static Item.Properties itemProperties() {
        return new Item.Properties().func_200916_a(Registries.creativeTab);
    }

    private static Item.Properties nonStackableItemProperties() {
        return OurItems.itemProperties().func_200917_a(1);
    }

    static {
        itemBuilders = new HashSet<Builder>();
    }

    private static final class Builder {
        private final ResourceLocation registryName;
        private Item.Properties builder;
        private Function<Item.Properties, Item> factory;

        private Builder(ResourceLocation registryName) {
            this.registryName = registryName;
        }

        private Builder setBuilder(Item.Properties builder) {
            this.builder = builder;
            return this;
        }

        private Builder setFactory(Function<Item.Properties, Item> factory) {
            this.factory = factory;
            return this;
        }

        private Item createItem() {
            return (Item)this.factory.apply(this.builder).setRegistryName(this.registryName);
        }
    }
}

