/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.ConnectedSurfaceSequence;
import com.direwolf20.buildinggadgets.common.building.placement.IPositionPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.placement.SurfaceSequence;
import com.direwolf20.buildinggadgets.common.util.tools.MathUtils;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public final class PlacementSequences {
    private PlacementSequences() {
    }

    public static final class ConnectedSurface {
        private ConnectedSurface() {
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            return ConnectedSurface.create(world, (BlockPos pos) -> pos.func_177972_a(side), searchingCenter, side, range, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            Region searchingRegion = Wall.clickedSide(searchingCenter, side, MathUtils.floorToOdd(range) / 2).getBoundingBox();
            return ConnectedSurface.create(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, boolean fuzzy) {
            return new ConnectedSurfaceSequence(world, searchingRegion, searching2referenceMapper, searchingCenter, side, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, @Nullable Direction side, BiPredicate<BlockState, BlockPos> predicate) {
            return new ConnectedSurfaceSequence(world, searchingRegion, searching2referenceMapper, searchingCenter, side, predicate);
        }
    }

    public static final class Surface {
        private Surface() {
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            return Surface.create(world, pos -> pos.func_177972_a(side), searchingCenter, side, range, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, Function<BlockPos, BlockPos> searching2referenceMapper, BlockPos searchingCenter, Direction side, int range, boolean fuzzy) {
            Region searchingRegion = Wall.clickedSide(searchingCenter, side, MathUtils.floorToOdd(range) / 2).getBoundingBox();
            return Surface.create(world, searchingCenter, searchingRegion, searching2referenceMapper, fuzzy);
        }

        public static IPositionPlacementSequence create(IBlockReader world, BlockPos center, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, boolean fuzzy) {
            return new SurfaceSequence(Objects.requireNonNull(world, "Surface mode is required to have at least an IBlockReader"), Objects.requireNonNull(center), Objects.requireNonNull(searchingRegion), Objects.requireNonNull(searching2referenceMapper), fuzzy);
        }
    }

    public static final class Wall {
        private Wall() {
        }

        public static IPositionPlacementSequence clickedSide(BlockPos center, Direction side, int radius) {
            return Wall.create(center, side, radius, null, 0);
        }

        private static IPositionPlacementSequence create(BlockPos posHit, Direction side, int radius, @Nullable Direction extendingSide, int extendingSize) {
            Region createdRegion = new Region((Vec3i)posHit).expand(radius * (1 - Math.abs(side.func_82601_c())), radius * (1 - Math.abs(side.func_96559_d())), radius * (1 - Math.abs(side.func_82599_e())));
            if (extendingSize != 0 && extendingSide != null) {
                createdRegion = extendingSide.func_176743_c() == Direction.AxisDirection.POSITIVE ? new Region((Vec3i)createdRegion.getMin(), (Vec3i)createdRegion.getMax().func_177967_a(extendingSide, extendingSize)) : new Region((Vec3i)createdRegion.getMin().func_177967_a(extendingSide, extendingSize), (Vec3i)createdRegion.getMax());
            }
            return createdRegion;
        }
    }
}

