/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.BlockAutoSwitch;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;

public class BlockEnvironmentalSensorSwitch
extends BlockAutoSwitch {
    public BlockEnvironmentalSensorSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public BlockEnvironmentalSensorSwitch(long config, Block.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityEnvironmentalSensorSwitch(ModContent.TET_ENVSENSOR_SWITCH);
    }

    public static class TileEntityEnvironmentalSensorSwitch
    extends BlockAutoSwitch.TileEntityAutoSwitch
    implements ITickableTileEntity {
        protected static final int debounce_max = 10;
        protected int update_interval_ = 10;
        protected double threshold0_on_ = 0.0;
        protected double threshold0_off_ = 0.0;
        protected int debounce_ = 0;
        protected int update_timer_ = 0;
        protected int debounce_counter_ = 0;

        public TileEntityEnvironmentalSensorSwitch(TileEntityType<?> te_type) {
            super(te_type);
        }

        public TileEntityEnvironmentalSensorSwitch() {
            super(ModContent.TET_ENVSENSOR_SWITCH);
        }

        public double threshold0_on() {
            return this.threshold0_on_;
        }

        public double threshold0_off() {
            return this.threshold0_off_;
        }

        public int debounce() {
            return this.debounce_;
        }

        public void threshold0_on(double v) {
            this.threshold0_on_ = v < 0.0 ? 0.0 : (v > 15.0 ? 15.0 : v);
        }

        public void threshold0_off(double v) {
            this.threshold0_off_ = v < 0.0 ? 0.0 : (v > 15.0 ? 15.0 : v);
        }

        public void debounce(int v) {
            this.debounce_ = v < 0 ? 0 : (v > 10 ? 10 : v);
        }

        @Override
        public void writeNbt(CompoundNBT nbt, boolean updatePacket) {
            super.writeNbt(nbt, updatePacket);
            nbt.func_74780_a("threshold0_on", this.threshold0_on());
            nbt.func_74780_a("threshold0_off", this.threshold0_off());
            nbt.func_74768_a("debounce", this.debounce());
        }

        @Override
        public void readNbt(CompoundNBT nbt, boolean updatePacket) {
            super.readNbt(nbt, updatePacket);
            this.threshold0_on(nbt.func_74769_h("threshold0_on"));
            this.threshold0_off(nbt.func_74769_h("threshold0_off"));
            this.debounce(nbt.func_74762_e("debounce"));
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if ((block.config & 0x1000000000L) != 0L) {
                switch (field) {
                    case 1: {
                        this.threshold0_on(this.threshold0_on() + (double)direction);
                        if (!(this.threshold0_off() > this.threshold0_on())) break;
                        this.threshold0_off(this.threshold0_on());
                        break;
                    }
                    case 2: {
                        this.threshold0_off(this.threshold0_off() + (double)direction);
                        if (!(this.threshold0_on() < this.threshold0_off())) break;
                        this.threshold0_on(this.threshold0_off());
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.threshold0_on() < 1.0) {
                    this.threshold0_on(1.0);
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                ArrayList<Object> tr = new ArrayList<Object>();
                TranslationTextComponent trunit = ModAuxiliaries.localizable("switchconfig.lightsensor.lightunit", null, new Object[0]);
                StringTextComponent separator = new StringTextComponent(" | ");
                separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
                tr.add(ModAuxiliaries.localizable("switchconfig.lightsensor.threshold_on", TextFormatting.BLUE, (int)this.threshold0_on(), trunit));
                tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.threshold_off", TextFormatting.YELLOW, (int)this.threshold0_off(), trunit)));
                tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.output_power", TextFormatting.RED, this.on_power())));
                if (this.debounce() > 0) {
                    tr.add(separator.func_212638_h().func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor.debounce", TextFormatting.DARK_GREEN, this.debounce())));
                } else {
                    tr.add(new StringTextComponent(""));
                }
                ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.lightsensor", TextFormatting.RESET, tr.toArray()));
            } else if ((block.config & 0x6000000000L) != 0L) {
                switch (field) {
                    case 4: {
                        this.on_power(this.on_power() + direction);
                    }
                }
                if (this.on_power() < 1) {
                    this.on_power(1);
                }
                if ((block.config & 0x2000000000L) != 0L) {
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.rainsensor.output_power", TextFormatting.RED, this.on_power()));
                } else {
                    ModAuxiliaries.playerStatusMessage(player, (ITextComponent)ModAuxiliaries.localizable("switchconfig.thundersensor.output_power", TextFormatting.RED, this.on_power()));
                }
            }
            this.func_70296_d();
            return true;
        }

        public void func_73660_a() {
            if (ModConfig.without_environmental_switch_update) {
                return;
            }
            if (!this.func_145830_o() || this.func_145831_w().field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockAutoSwitch)) {
                return;
            }
            BlockAutoSwitch block = (BlockAutoSwitch)state.func_177230_c();
            boolean active = (Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED);
            if ((block.config & 0x1000000000L) != 0L) {
                if (this.threshold0_on() == 0.0 && this.threshold0_off() == 0.0) {
                    this.threshold0_on(7.0);
                    this.threshold0_off(6.0);
                } else {
                    double value = this.func_145831_w().func_201696_r(this.field_174879_c);
                    int measurement = 0;
                    if (this.threshold0_off() >= this.threshold0_on()) {
                        measurement += value == this.threshold0_on() ? 1 : -1;
                    } else {
                        if (value >= this.threshold0_on()) {
                            measurement = 1;
                        }
                        if (value <= this.threshold0_off()) {
                            measurement = -1;
                        }
                    }
                    if (this.debounce() <= 0) {
                        if (measurement != 0) {
                            active = measurement > 0;
                        }
                        this.debounce_counter_ = 0;
                    } else {
                        this.debounce_counter_ += measurement;
                        if (this.debounce_counter_ <= 0) {
                            active = false;
                            this.debounce_counter_ = 0;
                        } else if (this.debounce_counter_ >= this.debounce_) {
                            active = true;
                            this.debounce_counter_ = this.debounce_;
                        }
                    }
                }
            } else if ((block.config & 0x2000000000L) != 0L) {
                if (state.func_177229_b((IProperty)RsDirectedBlock.FACING) != Direction.UP && state.func_177229_b((IProperty)RsDirectedBlock.FACING) != Direction.DOWN) {
                    this.debounce_counter_ += this.func_145831_w().func_175727_C(this.func_174877_v().func_177967_a(Direction.UP, 1)) ? 1 : -1;
                    if (this.debounce_counter_ <= 0) {
                        this.debounce_counter_ = 0;
                        active = false;
                    } else if (this.debounce_counter_ >= 4) {
                        this.debounce_counter_ = 4;
                        active = true;
                    }
                }
            } else if ((block.config & 0x4000000000L) != 0L) {
                this.debounce_counter_ += this.func_145831_w().func_72911_I() && (this.func_145831_w().func_175727_C(this.func_174877_v()) || this.func_145831_w().func_175727_C(this.func_174877_v().func_177967_a(Direction.UP, 20))) ? 1 : -1;
                if (this.debounce_counter_ <= 0) {
                    this.debounce_counter_ = 0;
                    active = false;
                } else if (this.debounce_counter_ >= 4) {
                    this.debounce_counter_ = 4;
                    active = true;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }
}

