/*
 * Decompiled with CFR 0.152.
 */
package cofh.omgourd;

import cofh.core.init.CoreItems;
import cofh.lib.block.deco.CarvedPumpkinBlockCoFH;
import cofh.lib.registries.DeferredRegisterCoFH;
import cofh.omgourd.data.OMGItemModels;
import cofh.omgourd.data.OMGLootTables;
import cofh.omgourd.data.OMGRecipeProvider;
import cofh.omgourd.init.OMGBlocks;
import cofh.omgourd.init.OMGConfig;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="omgourd")
public class OMGourd {
    public static final Logger LOG = LogManager.getLogger((String)"omgourd");
    public static final DeferredRegisterCoFH<Block> BLOCKS = new DeferredRegisterCoFH(ForgeRegistries.BLOCKS, "omgourd");
    public static final DeferredRegisterCoFH<Item> ITEMS = new DeferredRegisterCoFH(ForgeRegistries.ITEMS, "omgourd");
    public static ItemGroup itemGroup;

    public OMGourd() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        OMGConfig.register();
        OMGBlocks.register();
        CoreItems.registerShearsOverride();
        CarvedPumpkinBlockCoFH.updateTest();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        OMGBlocks.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        itemGroup = (Boolean)OMGConfig.enableCreativeTab.get() != false ? new ItemGroup(-1, "omgourd"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ITEMS.get("carved_pumpkin_1"));
            }
        } : ItemGroup.field_78030_b;
    }

    private void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            this.registerServerProviders(event.getGenerator());
        }
        if (event.includeClient()) {
            this.registerClientProviders(event.getGenerator(), event);
        }
    }

    private void registerServerProviders(DataGenerator generator) {
        generator.func_200390_a((IDataProvider)new OMGLootTables(generator));
        generator.func_200390_a((IDataProvider)new OMGRecipeProvider(generator));
    }

    private void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        generator.func_200390_a((IDataProvider)new OMGItemModels(generator, event.getExistingFileHelper()));
    }
}

