/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.stal111.forbidden_arcanus.block.WaterloggedBlock;
import com.stal111.forbidden_arcanus.block.properties.ConnectedBlockType;
import com.stal111.forbidden_arcanus.util.VoxelShapeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class PillarBlock
extends WaterloggedBlock {
    public static final EnumProperty<ConnectedBlockType> TYPE = EnumProperty.func_177709_a((String)"type", ConnectedBlockType.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    private static final VoxelShape[] SHAPE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};

    private VoxelShape generateShape(BlockState state) {
        if (state.func_177229_b(TYPE) == ConnectedBlockType.SINGLE) {
            return VoxelShapeHelper.rotateShapeAxis(VoxelShapeHelper.combineAll(SHAPE), (Direction.Axis)state.func_177229_b(AXIS));
        }
        if (state.func_177229_b(TYPE) == ConnectedBlockType.TOP) {
            return VoxelShapeHelper.rotateShapeAxis(VoxelShapeHelper.combineAll(SHAPE[0], SHAPE[1], SHAPE[2]), (Direction.Axis)state.func_177229_b(AXIS));
        }
        if (state.func_177229_b(TYPE) == ConnectedBlockType.CENTER) {
            return VoxelShapeHelper.rotateShapeAxis(SHAPE[2], (Direction.Axis)state.func_177229_b(AXIS));
        }
        return VoxelShapeHelper.rotateShapeAxis(VoxelShapeHelper.combineAll(SHAPE[2], SHAPE[3], SHAPE[4]), (Direction.Axis)state.func_177229_b(AXIS));
    }

    public PillarBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y)).func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, AXIS, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.generateShape(state);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a(TYPE, (Comparable)((Object)ConnectedBlockType.SINGLE))).func_206870_a(AXIS, (Comparable)context.func_196000_l().func_176740_k())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)this.tryConnect(state, world, currentPos)));
    }

    public ConnectedBlockType tryConnect(BlockState state, IWorld world, BlockPos pos) {
        BlockState stateUp;
        BlockState stateDown;
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS);
        if (axis == Direction.Axis.X) {
            stateDown = world.func_180495_p(pos.func_177976_e());
            stateUp = world.func_180495_p(pos.func_177974_f());
        } else if (axis == Direction.Axis.Z) {
            stateDown = world.func_180495_p(pos.func_177968_d());
            stateUp = world.func_180495_p(pos.func_177978_c());
        } else {
            stateDown = world.func_180495_p(pos.func_177977_b());
            stateUp = world.func_180495_p(pos.func_177984_a());
        }
        boolean axisUpEqual = false;
        boolean axisDownEqual = false;
        if (stateUp.func_177230_c() instanceof PillarBlock) {
            boolean bl = axisUpEqual = stateUp.func_177229_b(AXIS) == axis;
        }
        if (stateDown.func_177230_c() instanceof PillarBlock) {
            boolean bl = axisDownEqual = stateDown.func_177229_b(AXIS) == axis;
        }
        if (axisUpEqual && axisDownEqual) {
            return ConnectedBlockType.CENTER;
        }
        if (axisUpEqual) {
            return ConnectedBlockType.BOTTOM;
        }
        if (axisDownEqual) {
            return ConnectedBlockType.TOP;
        }
        return ConnectedBlockType.SINGLE;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }
}

