/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.citadel.server.entity.PropertiesTracker;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerProxy {
    public void onPreInit() {
    }

    public void handleAnimationPacket(int entityId, int index) {
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegistryEvent.Register<Item> registry) {
        registry.getRegistry().register((IForgeRegistryEntry)Citadel.DEBUG);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        List<PropertiesTracker<?>> trackers = EntityPropertiesHandler.INSTANCE.getEntityTrackers(player);
        if (trackers != null && trackers.size() > 0) {
            PropertiesTracker<?> tracker2;
            boolean hasPlayer = false;
            Iterator<PropertiesTracker<?>> iterator = trackers.iterator();
            while (iterator.hasNext() && !(hasPlayer = (tracker2 = iterator.next()).getEntity() == player)) {
            }
            if (!hasPlayer) {
                EntityPropertiesHandler.INSTANCE.addTracker(player, player);
            }
            for (PropertiesTracker<?> tracker2 : trackers) {
                tracker2.updateTracker();
                if (!tracker2.isTrackerReady()) continue;
                tracker2.onSync();
                PropertiesMessage message = new PropertiesMessage(tracker2.getProperties(), (Entity)tracker2.getEntity());
                Citadel.NETWORK_WRAPPER.sendTo((Object)message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

