/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.player.PlayerRestriction;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.maciej916.maessentials.libs.Time;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandTempban {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"tempban").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandTempban.tempban((CommandContext<CommandSource>)context))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandTempban.tempbanPlayer((CommandContext<CommandSource>)context))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"time", (ArgumentType)StringArgumentType.word()).executes(context -> CommandTempban.tempbanPlayerTime((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"reason", (ArgumentType)MessageArgument.func_197123_a()).executes(context -> CommandTempban.tempbanPlayerReason((CommandContext<CommandSource>)context)))));
        dispatcher.register(builder);
    }

    private static int tempban(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("maessentials.provide.player", new Object[0]));
        return 1;
    }

    private static int tempbanPlayer(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("tempban.maessentials.provide.time", new Object[0]));
        return 1;
    }

    private static int tempbanPlayerTime(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        String time = StringArgumentType.getString(context, (String)"time");
        CommandTempban.doTempban(player, targetPlayer, time, "No reason provided");
        return 1;
    }

    private static int tempbanPlayerReason(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        String time = StringArgumentType.getString(context, (String)"time").toLowerCase();
        ITextComponent reason = MessageArgument.func_197124_a(context, (String)"reason");
        CommandTempban.doTempban(player, targetPlayer, time, reason.getString());
        return 1;
    }

    private static void doTempban(ServerPlayerEntity player, ServerPlayerEntity target, String time, String reason) {
        EssentialPlayer eslTargetPlayer = DataManager.getPlayer(target);
        PlayerRestriction ban = eslTargetPlayer.getRestrictions().getBan();
        long banTime = Time.parseDate(time, true);
        if (time.equals("perm")) {
            banTime = -1L;
        }
        if (banTime == 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.illegal_date", new Object[0]));
            return;
        }
        if (ban != null && (Methods.currentTimestamp() < ban.getTime() || ban.getTime() == -1L)) {
            player.func_145747_a((ITextComponent)Methods.formatText("tempban.maessentials.already_banned", target.func_145748_c_()));
            return;
        }
        eslTargetPlayer.getRestrictions().setBan(banTime, reason);
        eslTargetPlayer.saveData();
        if (banTime == -1L) {
            player.field_71133_b.func_184103_al().func_148539_a((ITextComponent)Methods.formatText("tempban.maessentials.success.perm", target.func_145748_c_(), player.func_145748_c_(), reason));
            target.field_71135_a.func_194028_b((ITextComponent)Methods.formatText("tempban.maessentials.success.perm.target", player.func_145748_c_(), reason));
        } else {
            String displayTime = Time.formatDate(banTime - Methods.currentTimestamp());
            player.field_71133_b.func_184103_al().func_148539_a((ITextComponent)Methods.formatText("tempban.maessentials.success", target.func_145748_c_(), player.func_145748_c_(), displayTime, reason));
            target.field_71135_a.func_194028_b((ITextComponent)Methods.formatText("tempban.maessentials.success.target", player.func_145748_c_(), displayTime, reason));
        }
    }
}

