/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerThermalCompressor;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityThermalCompressor
extends TileEntityPneumaticBase
implements IHeatTinted,
IRedstoneControlled,
INamedContainerProvider {
    private static final double AIR_GEN_MULTIPLIER = 0.05;
    private double[] generated = new double[2];
    @GuiSynced
    private final IHeatExchangerLogic[] heatExchangers = new IHeatExchangerLogic[4];
    private List<LazyOptional<IHeatExchangerLogic>> heatCaps = new ArrayList<LazyOptional<IHeatExchangerLogic>>(4);
    private final IHeatExchangerLogic connector1;
    private final IHeatExchangerLogic connector2;
    private final IHeatExchangerLogic dummyExchanger;
    @DescSynced
    private SyncedTemperature[] syncedTemperatures = new SyncedTemperature[4];
    @GuiSynced
    private int redstoneMode;

    public TileEntityThermalCompressor() {
        super((TileEntityType)ModTileEntities.THERMAL_COMPRESSOR.get(), 5.0f, 7.0f, 5000, 4);
        IntStream.range(0, this.heatExchangers.length).forEach(i -> {
            this.heatExchangers[i] = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
            this.heatExchangers[i].setThermalCapacity(2.0);
            this.heatCaps.add((LazyOptional<IHeatExchangerLogic>)LazyOptional.of(() -> this.heatExchangers[i]));
        });
        for (int i2 = 0; i2 < this.syncedTemperatures.length; ++i2) {
            this.syncedTemperatures[i2] = new SyncedTemperature();
        }
        this.connector1 = this.makeConnector(Direction.NORTH);
        this.connector2 = this.makeConnector(Direction.EAST);
        this.dummyExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    }

    private IHeatExchangerLogic makeConnector(Direction side) {
        IHeatExchangerLogic connector = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
        connector.setThermalResistance(PNCConfig.Common.Machines.thermalCompressorThermalResistance);
        connector.addConnectedExchanger(this.heatExchangers[side.func_176736_b()]);
        connector.addConnectedExchanger(this.heatExchangers[side.func_176734_d().func_176736_b()]);
        return connector;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            for (IHeatExchangerLogic heatExchanger : this.heatExchangers) {
                heatExchanger.tick();
            }
            if (this.redstoneAllows()) {
                this.connector1.setThermalResistance(PNCConfig.Common.Machines.thermalCompressorThermalResistance);
                this.connector2.setThermalResistance(PNCConfig.Common.Machines.thermalCompressorThermalResistance);
            } else {
                this.connector1.setThermalResistance(PNCConfig.Common.Machines.thermalCompressorThermalResistance * 100.0);
                this.connector2.setThermalResistance(PNCConfig.Common.Machines.thermalCompressorThermalResistance * 100.0);
            }
            this.connector1.tick();
            this.connector2.tick();
            if (this.redstoneAllows()) {
                this.generatePressure(0);
                this.generatePressure(1);
            }
            for (int i = 0; i < 4; ++i) {
                this.syncedTemperatures[i].setCurrentTemp(this.heatExchangers[i].getTemperature());
            }
        }
    }

    public double airProduced(int side) {
        if (this.field_145850_b.field_72995_K) {
            double diff = Math.abs(this.heatExchangers[side].getTemperatureAsInt() - this.heatExchangers[side + 2].getTemperatureAsInt());
            return diff * 0.05;
        }
        double diff = Math.abs(this.heatExchangers[side].getTemperature() - this.heatExchangers[side + 2].getTemperature());
        return diff * 0.05;
    }

    private void generatePressure(int side) {
        int n = side;
        this.generated[n] = this.generated[n] + this.airProduced(side);
        if (this.generated[side] > 1.0) {
            int toAdd = (int)this.generated[side];
            this.addAir(toAdd);
            int n2 = side;
            this.generated[n2] = this.generated[n2] - (double)toAdd;
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return HeatUtil.getColourForTemperature(this.syncedTemperatures[tintIndex].getSyncedTemp());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 4; ++i) {
            tag.func_218657_a("side" + i, this.heatExchangers[i].serializeNBT());
        }
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 4; ++i) {
            this.heatExchangers[i].deserializeNBT((INBT)tag.func_74775_l("side" + i));
        }
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void handleGUIButtonPress(String guiID, boolean shiftHeld, PlayerEntity player) {
        if (guiID.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerThermalCompressor(i, playerInventory, this.func_174877_v());
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        if (side == null) {
            return LazyOptional.of(() -> this.dummyExchanger);
        }
        return side.func_176740_k() == Direction.Axis.Y ? LazyOptional.empty() : this.heatCaps.get(side.func_176736_b());
    }
}

