/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityHeatPipe
extends TileEntityTickableBase
implements ICamouflageableTE {
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState;

    public TileEntityHeatPipe() {
        super((TileEntityType)ModTileEntities.HEAT_PIPE.get());
        this.heatExchanger.setThermalResistance(0.01);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    protected BiPredicate<IWorld, BlockPos> heatExchangerBlockFilter() {
        return (world, pos) -> !world.func_175623_d(pos) && !(world.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock);
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        BlockState state = this.func_195044_w();
        boolean changed = false;
        for (Direction dir : Direction.field_199792_n) {
            BooleanProperty prop = BlockPneumaticCraft.connectionProperty(dir);
            boolean connected = this.heatExchanger.isSideConnected(dir);
            if ((Boolean)state.func_177229_b((IProperty)prop) == connected) continue;
            state = (BlockState)state.func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(connected));
            changed = true;
        }
        if (changed) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        super.onDescUpdate();
    }
}

