/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class ProgWidgetLiquidInventoryCondition
extends ProgWidgetCondition {
    public ProgWidgetLiquidInventoryCondition() {
        super(ModProgWidgets.CONDITION_LIQUID_INVENTORY);
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.LIQUID_FILTER, ModProgWidgets.TEXT);
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                TileEntity te = this.drone.world().func_175625_s(pos);
                int count = te == null ? this.countFluid(this.drone.world(), pos) : this.countFluid(te);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(count, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }

            private int countFluid(World world, BlockPos pos) {
                IFluidState state = world.func_204610_c(pos);
                if (ProgWidgetLiquidFilter.isLiquidValid(state.func_206886_c(), this.progWidget, 1)) {
                    return 1000;
                }
                return 0;
            }

            private int countFluid(TileEntity te) {
                return (Integer)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> {
                    int total = 0;
                    for (int i = 0; i < handler.getTanks(); ++i) {
                        FluidStack stack = handler.getFluidInTank(i);
                        if (stack.isEmpty() || !ProgWidgetLiquidFilter.isLiquidValid(stack.getFluid(), this.progWidget, 1)) continue;
                        total += stack.getAmount();
                    }
                    return total;
                }).orElse((Object)0);
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_LIQUID_INVENTORY;
    }
}

