/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};
    private boolean useCount;
    private int count = 1;

    public ProgWidgetInventoryBase(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add(PneumaticCraftUtils.xlate("gui.progWidget.inventory.accessingSides", new Object[0]));
        }
        curTooltip.add((ITextComponent)new StringTextComponent(this.getExtraStringInfo()));
        if (this.useCount) {
            curTooltip.add(PneumaticCraftUtils.xlate("gui.progWidget.inventory.usingCount", this.count));
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public String getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return "ALL";
        }
        if (noSides) {
            return "NONE";
        }
        List l = Arrays.stream(Direction.field_199792_n).filter(side -> this.accessingSides[side.func_176745_a()]).map(Direction::func_176610_l).collect(Collectors.toList());
        return Strings.join(l, (String)", ");
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a(Direction.func_82600_a((int)i).name(), this.accessingSides[i]);
        }
        tag.func_74757_a("useCount", this.useCount);
        tag.func_74768_a("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(Direction.func_82600_a((int)i).name());
        }
        this.useCount = tag.func_74767_n("useCount");
        this.count = tag.func_74762_e("count");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        for (int i = 0; i < 6; ++i) {
            buf.writeBoolean(this.accessingSides[i]);
        }
        buf.writeBoolean(this.useCount);
        buf.func_150787_b(this.count);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = buf.readBoolean();
        }
        this.useCount = buf.readBoolean();
        this.count = buf.func_150792_a();
    }
}

