/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRedstone;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncRedstoneModuleToServer
extends LocationIntPacket {
    private byte side;
    private byte op;
    private byte ourColor;
    private byte otherColor;
    private byte constantVal;
    private boolean invert;

    public PacketSyncRedstoneModuleToServer() {
    }

    public PacketSyncRedstoneModuleToServer(ModuleRedstone module) {
        super(module.getTube().func_174877_v());
        this.side = (byte)module.getDirection().ordinal();
        this.op = (byte)module.getOperation().ordinal();
        this.ourColor = (byte)module.getColorChannel();
        this.otherColor = (byte)module.getOtherColor();
        this.constantVal = (byte)module.getConstantVal();
        this.invert = module.isInverted();
    }

    PacketSyncRedstoneModuleToServer(PacketBuffer buffer) {
        super(buffer);
        this.side = buffer.readByte();
        this.op = buffer.readByte();
        this.ourColor = buffer.readByte();
        this.otherColor = buffer.readByte();
        this.constantVal = buffer.readByte();
        this.invert = buffer.readBoolean();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte((int)this.side);
        buf.writeByte((int)this.op);
        buf.writeByte((int)this.ourColor);
        buf.writeByte((int)this.otherColor);
        buf.writeByte((int)this.constantVal);
        buf.writeBoolean(this.invert);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TubeModule m;
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_175625_s(this.pos);
            if (te instanceof TileEntityPressureTube && (m = ((TileEntityPressureTube)te).modules[this.side]) instanceof ModuleRedstone) {
                ModuleRedstone mr = (ModuleRedstone)m;
                mr.setColorChannel(this.ourColor);
                mr.setInverted(this.invert);
                mr.setOperation(ModuleRedstone.Operation.values()[this.op], this.otherColor, this.constantVal);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

