/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncAmadronOffers {
    private final Collection<AmadronOffer> activeOffers;

    public PacketSyncAmadronOffers() {
        this.activeOffers = AmadronOfferManager.getInstance().getActiveOffers();
    }

    public PacketSyncAmadronOffers(PacketBuffer buf) {
        this.activeOffers = this.readOffers(buf);
    }

    private Collection<AmadronOffer> readOffers(PacketBuffer buf) {
        int offerCount = buf.func_150792_a();
        ArrayList<AmadronOffer> offers = new ArrayList<AmadronOffer>();
        for (int i = 0; i < offerCount; ++i) {
            if (buf.readBoolean()) {
                offers.add(AmadronPlayerOffer.loadFromBuf(buf));
                continue;
            }
            offers.add(AmadronOffer.readFromBuf(buf));
        }
        return offers;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.activeOffers.size());
        for (AmadronOffer offer : this.activeOffers) {
            buf.writeBoolean(offer instanceof AmadronPlayerOffer);
            buf.func_192572_a(offer.func_199560_c());
            offer.write(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> AmadronOfferManager.getInstance().syncOffers(this.activeOffers));
        ctx.get().setPacketHandled(true);
    }
}

