/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.handler;

import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.item.ItemStack;

public class ChargeableItemHandler
extends BaseItemStackHandler {
    public ChargeableItemHandler(TileEntityChargingStation te) {
        super(te, 9);
        if (!NBTUtil.hasTag(this.getChargingStack(), "UpgradeInventory")) {
            this.writeToNBT();
        }
        this.readFromNBT();
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.writeToNBT();
    }

    private ItemStack getChargingStack() {
        return ((TileEntityChargingStation)this.te).getChargingStack();
    }

    public void writeToNBT() {
        UpgradableItemUtils.setUpgrades(this.getChargingStack(), this);
    }

    private void readFromNBT() {
        this.deserializeNBT(NBTUtil.getCompoundTag(this.getChargingStack(), "UpgradeInventory"));
    }

    public boolean isItemValid(int slot, ItemStack itemStack) {
        return itemStack.func_190926_b() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
    }

    private boolean isUnique(int slot, ItemStack stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (i == slot || EnumUpgrade.from(stack) != EnumUpgrade.from(this.getStackInSlot(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isApplicable(ItemStack stack) {
        return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.getChargingStack().func_77973_b(), EnumUpgrade.from(stack)) > 0;
    }
}

