/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleCharging
extends TubeModule {
    private TileEntityCache connectedInventory;
    private LazyOptional<IItemHandler> cachedHandler = LazyOptional.empty();

    public ModuleCharging(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    @Override
    public void update() {
        super.update();
        if (this.pressureTube.func_145831_w().field_72995_K || (this.pressureTube.func_145831_w().func_82737_E() & 7L) != 0L) {
            return;
        }
        if (!this.cachedHandler.isPresent()) {
            this.cachedHandler = this.getConnectedInventory();
            if (this.cachedHandler.isPresent()) {
                this.cachedHandler.addListener(h -> {
                    this.cachedHandler = LazyOptional.empty();
                });
            }
        }
        this.cachedHandler.ifPresent(itemHandler -> {
            int airToTransfer = 80 * (this.upgraded ? 10 : 1);
            this.pressureTube.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
                int airInTube = (int)(airHandler.getPressure() * (float)airHandler.getVolume());
                for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                    ItemStack chargedItem = itemHandler.getStackInSlot(slot);
                    int airInTube2 = airInTube;
                    int toAdd = (Integer)chargedItem.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                        float itemPressure = h.getPressure();
                        float itemVolume = h.getVolume();
                        float delta = Math.abs(airHandler.getPressure() - itemPressure) / 2.0f;
                        int airInItem = (int)(itemPressure * itemVolume);
                        if (itemPressure > airHandler.getPressure() + 0.01f && itemPressure > 0.0f) {
                            int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)airHandler.getVolume()));
                            h.addAir(-airToMove);
                            airHandler.addAir(airToMove);
                            return airToMove;
                        }
                        if (itemPressure < airHandler.getPressure() - 0.01f && itemPressure < h.maxPressure()) {
                            int maxAirInItem = (int)(h.maxPressure() * itemVolume);
                            int airToMove = Math.min(Math.min(airToTransfer, airInTube2), maxAirInItem - airInItem);
                            airToMove = Math.min((int)(delta * itemVolume), airToMove);
                            h.addAir(airToMove);
                            airHandler.addAir(-airToMove);
                        }
                        return 0;
                    }).orElse((Object)0);
                    airInTube += toAdd;
                }
            });
        });
    }

    @Override
    public void onNeighborTileUpdate() {
        this.connectedInventory = null;
    }

    private LazyOptional<IItemHandler> getConnectedInventory() {
        TileEntity te;
        if (this.connectedInventory == null) {
            this.connectedInventory = new TileEntityCache(this.pressureTube.func_145831_w(), this.pressureTube.func_174877_v().func_177972_a(this.dir));
        }
        return (te = this.connectedInventory.getTileEntity()) == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.dir.func_176734_d());
    }
}

