/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class DroneAIDig<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIDig(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        BlockState blockState = this.worldCache.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!this.worldCache.func_180495_p(pos).isAir((IBlockReader)this.worldCache, pos) && !DroneAIDig.ignoreBlock(block)) {
            for (ItemStack droppedStack : DroneAIDig.getDrops((IBlockReader)this.worldCache, pos, this.drone)) {
                if (!this.progWidget.isItemValidForFilters(droppedStack, blockState)) continue;
                return this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool();
            }
            if (this.progWidget.isItemValidForFilters(ItemStack.field_190927_a, blockState)) {
                return this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool();
            }
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    private boolean swapBestItemToFirstSlot(BlockPos pos) {
        ItemStack currentStackSaved = this.drone.getInv().getStackInSlot(0).func_77946_l();
        this.drone.getInv().setStackInSlot(0, ItemStack.field_190927_a);
        float baseSoftness = this.worldCache.func_180495_p(pos).func_185903_a((PlayerEntity)this.drone.getFakePlayer(), (IBlockReader)this.drone.world(), pos);
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        boolean hasDiggingTool = false;
        int bestSlot = 0;
        float bestSoftness = Float.MIN_VALUE;
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            this.drone.getInv().setStackInSlot(0, this.drone.getInv().getStackInSlot(i));
            float softness = this.worldCache.func_180495_p(pos).func_185903_a((PlayerEntity)this.drone.getFakePlayer(), (IBlockReader)this.drone.world(), pos);
            if (!(softness > bestSoftness)) continue;
            bestSlot = i;
            bestSoftness = softness;
            if (!(softness > baseSoftness)) continue;
            hasDiggingTool = true;
        }
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        if (bestSlot != 0) {
            ItemStack bestItem = this.drone.getInv().getStackInSlot(bestSlot).func_77946_l();
            this.drone.getInv().setStackInSlot(bestSlot, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, bestItem);
        }
        return hasDiggingTool;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        PlayerInteractionManager manager = this.drone.getFakePlayer().field_71134_c;
        if (!manager.field_73088_d || !manager.field_73097_j) {
            BlockState blockState = this.worldCache.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (!DroneAIDig.ignoreBlock(block) && DroneAIDig.isBlockValidForFilter((IBlockReader)this.worldCache, pos, this.drone, this.progWidget)) {
                if (blockState.func_185887_b((IBlockReader)this.drone.world(), pos) < 0.0f) {
                    this.addToBlacklist(pos);
                    this.drone.addDebugEntry("gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(null);
                    return false;
                }
                int limit = this.drone.world().func_73046_m().func_71207_Z();
                manager.func_225416_a(pos, CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, Direction.DOWN, limit);
                manager.func_225416_a(pos, CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, Direction.DOWN, limit);
                this.drone.setDugBlock(pos);
                return true;
            }
            this.drone.setDugBlock(null);
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForFilter(IBlockReader worldCache, BlockPos pos, IDroneBase drone, ProgWidgetAreaItemBase widget) {
        BlockState blockState = worldCache.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.isAir(blockState, worldCache, pos)) {
            for (ItemStack droppedStack : DroneAIDig.getDrops(worldCache, pos, drone)) {
                if (!widget.isItemValidForFilters(droppedStack, blockState)) continue;
                return true;
            }
            return widget.isItemValidForFilters(ItemStack.field_190927_a, blockState);
        }
        return false;
    }

    private static List<ItemStack> getDrops(IBlockReader worldCache, BlockPos pos, IDroneBase drone) {
        BlockState state = worldCache.func_180495_p(pos);
        return state.func_215693_a(new LootContext.Builder((ServerWorld)drone.world()).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216289_i, (Object)drone.getInv().getStackInSlot(0)));
    }

    private static boolean ignoreBlock(Block block) {
        return PneumaticCraftUtils.isBlockLiquid(block);
    }
}

