/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class PneumaticCraftTags {
    static <T extends Tag<?>> T tag(Function<ResourceLocation, T> creator, String modid, String name) {
        return (T)((Tag)creator.apply(new ResourceLocation(modid, name)));
    }

    static <T extends Tag<?>> T modTag(Function<ResourceLocation, T> creator, String name) {
        return PneumaticCraftTags.tag(creator, "pneumaticcraft", name);
    }

    static <T extends Tag<?>> T forgeTag(Function<ResourceLocation, T> creator, String name) {
        return PneumaticCraftTags.tag(creator, "forge", name);
    }

    public static class Fluids
    extends PneumaticCraftTags {
        public static final Tag<Fluid> OIL = Fluids.modTag("oil");
        public static final Tag<Fluid> ETCHING_ACID = Fluids.modTag("etching_acid");
        public static final Tag<Fluid> PLASTIC = Fluids.modTag("plastic");
        public static final Tag<Fluid> DIESEL = Fluids.modTag("diesel");
        public static final Tag<Fluid> KEROSENE = Fluids.modTag("kerosene");
        public static final Tag<Fluid> GASOLINE = Fluids.modTag("gasoline");
        public static final Tag<Fluid> LPG = Fluids.modTag("lpg");
        public static final Tag<Fluid> LUBRICANT = Fluids.modTag("lubricant");

        static Tag<Fluid> tag(String modid, String name) {
            return Fluids.tag(FluidTags.Wrapper::new, modid, name);
        }

        static Tag<Fluid> modTag(String name) {
            return Fluids.tag("pneumaticcraft", name);
        }

        static Tag<Fluid> forgeTag(String name) {
            return Fluids.tag("forge", name);
        }
    }

    public static class Items
    extends PneumaticCraftTags {
        public static final Tag<Item> SLABS = Items.modTag("slabs");
        public static final Tag<Item> STAIRS = Items.modTag("stairs");
        public static final Tag<Item> DOORS = Items.modTag("doors");
        public static final Tag<Item> WALLS = Items.modTag("walls");
        public static final Tag<Item> PLASTIC_BRICKS = Items.modTag("plastic_bricks");
        public static final Tag<Item> FLUID_TANKS = Items.modTag("fluid_tanks");
        public static final Tag<Item> CHESTS = Items.modTag("chests");
        public static final Tag<Item> REINFORCED_STONE = Items.modTag("reinforced_stone");
        public static final Tag<Item> REINFORCED_STONE_BRICKS = Items.modTag("reinforced_stone_bricks");
        public static final Tag<Item> UPGRADE_COMPONENTS = Items.modTag("upgrade_components");
        public static final Tag<Item> BASIC_DRONES = Items.modTag("basic_drones");
        public static final Tag<Item> PLASTIC_SHEETS = Items.modTag("plastic_sheets");
        public static final Tag<Item> INGOTS_COMPRESSED_IRON = Items.forgeTag("ingots/compressed_iron");
        public static final Tag<Item> STORAGE_BLOCKS_COMPRESSED_IRON = Items.forgeTag("storage_blocks/compressed_iron");

        static Tag<Item> tag(String modid, String name) {
            return Items.tag(ItemTags.Wrapper::new, modid, name);
        }

        static Tag<Item> modTag(String name) {
            return Items.tag("pneumaticcraft", name);
        }

        static Tag<Item> forgeTag(String name) {
            return Items.tag("forge", name);
        }
    }

    public static class Blocks
    extends PneumaticCraftTags {
        public static final Tag<Block> SLABS = Blocks.modTag("slabs");
        public static final Tag<Block> STAIRS = Blocks.modTag("stairs");
        public static final Tag<Block> DOORS = Blocks.modTag("doors");
        public static final Tag<Block> WALLS = Blocks.modTag("walls");
        public static final Tag<Block> PLASTIC_BRICKS = Blocks.modTag("plastic_bricks");
        public static final Tag<Block> FLUID_TANKS = Blocks.modTag("fluid_tanks");
        public static final Tag<Block> CHESTS = Blocks.modTag("chests");
        public static final Tag<Block> REINFORCED_STONE = Blocks.modTag("reinforced_stone");
        public static final Tag<Block> REINFORCED_STONE_BRICKS = Blocks.modTag("reinforced_stone_bricks");
        public static final Tag<Block> STORAGE_BLOCKS_COMPRESSED_IRON = Blocks.forgeTag("storage_blocks/compressed_iron");

        static Tag<Block> tag(String modid, String name) {
            return Blocks.tag(BlockTags.Wrapper::new, modid, name);
        }

        static Tag<Block> modTag(String name) {
            return Blocks.tag("pneumaticcraft", name);
        }

        static Tag<Block> forgeTag(String name) {
            return Blocks.tag("forge", name);
        }
    }
}

