/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class WidgetAmadronOffer
extends Widget
implements ITooltipProvider {
    private final AmadronOffer offer;
    private final List<Widget> subWidgets = new ArrayList<Widget>();
    private int shoppingAmount;
    private boolean canBuy;
    private final Rectangle2d[] tooltipRectangles = new Rectangle2d[2];
    private boolean renderBackground = true;

    public WidgetAmadronOffer(int x, int y, AmadronOffer offer) {
        super(x, y, 73, 35, "");
        this.offer = offer;
        if (offer.getInput().getType() == AmadronTradeResource.Type.FLUID) {
            this.subWidgets.add(new WidgetFluidStack(x + 6, y + 15, offer.getInput().getFluid(), null));
        }
        if (offer.getOutput().getType() == AmadronTradeResource.Type.FLUID) {
            this.subWidgets.add(new WidgetFluidStack(x + 51, y + 15, offer.getOutput().getFluid(), null));
        }
        this.tooltipRectangles[0] = new Rectangle2d(x + 6, y + 15, 16, 16);
        this.tooltipRectangles[1] = new Rectangle2d(x + 51, y + 15, 16, 16);
    }

    public void renderButton(int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            if (this.renderBackground) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.WIDGET_AMADRON_OFFER);
                RenderSystem.color4f((float)1.0f, (float)(this.canBuy ? 1.0f : 0.4f), (float)(this.canBuy ? 1.0f : 0.4f), (float)(this.canBuy ? 0.75f : 1.0f));
                AbstractGui.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)256, (int)256);
            }
            for (Widget widget : this.subWidgets) {
                widget.render(mouseX, mouseY, partialTick);
            }
            fr.func_211126_b(this.offer.getVendor(), (float)(this.x + 2), (float)(this.y + 2), -16777216);
            boolean playerOffer = this.offer instanceof AmadronPlayerOffer;
            if (this.shoppingAmount > 0) {
                fr.func_211126_b(TextFormatting.BLACK.toString() + this.shoppingAmount, (float)(this.x + 36) - (float)fr.func_78256_a("" + this.shoppingAmount) / 2.0f, (float)(this.y + (playerOffer ? 15 : 20)), -16777216);
            }
            if (playerOffer) {
                AmadronPlayerOffer custom = (AmadronPlayerOffer)this.offer;
                fr.func_211126_b(TextFormatting.DARK_BLUE.toString() + custom.getStock(), (float)(this.x + 36) - (float)fr.func_78256_a("" + custom.getStock()) / 2.0f, (float)(this.y + 25), -16777216);
            }
        }
    }

    public WidgetAmadronOffer setDrawBackground(boolean drawBackground) {
        this.renderBackground = drawBackground;
        return this;
    }

    public WidgetAmadronOffer setCanBuy(boolean canBuy) {
        this.canBuy = canBuy;
        return this;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shiftPressed) {
        for (Widget widget : this.subWidgets) {
            if (!widget.isHovered() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTip, shiftPressed);
        }
        boolean isInBounds = false;
        for (Rectangle2d rect : this.tooltipRectangles) {
            if (!rect.func_199315_b((int)mouseX, (int)mouseY)) continue;
            isInBounds = true;
        }
        if (!isInBounds) {
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.vendor", (Object[])new Object[]{this.offer.getVendor()}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.selling", (Object[])new Object[]{this.offer.getOutput().toString()}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.buying", (Object[])new Object[]{this.offer.getInput().toString()}));
            curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.inBasket", (Object[])new Object[]{this.shoppingAmount}));
            if (this.offer.getStock() >= 0) {
                curTip.add(I18n.func_135052_a((String)"gui.amadron.amadronWidget.stock", (Object[])new Object[]{this.offer.getStock()}));
            }
            if (this.offer.getVendor().equals(Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName())) {
                curTip.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"gui.amadron.amadronWidget.sneakRightClickToRemove", (Object[])new Object[0]), 40));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                curTip.add(TextFormatting.DARK_GRAY.toString() + this.offer.func_199560_c());
            }
        }
    }

    public AmadronOffer getOffer() {
        return this.offer;
    }

    public void setShoppingAmount(int amount) {
        this.shoppingAmount = amount;
    }
}

